<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateSecurityToken StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateSecurityToken
 * @subpackage Structs
 */
class ValidateSecurityToken extends CarrierInfo
{
    /**
     * The SecurityToken
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SecurityToken;
    /**
     * The ValidateSecurityTokenRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ValidateSecurityToken
     */
    public $ValidateSecurityTokenRequest;
    /**
     * Constructor method for ValidateSecurityToken
     * @uses ValidateSecurityToken::setSecurityToken()
     * @uses ValidateSecurityToken::setValidateSecurityTokenRequest()
     * @param string $securityToken
     * @param \StructType\ValidateSecurityToken $validateSecurityTokenRequest
     */
    public function __construct($securityToken = null, \StructType\ValidateSecurityToken $validateSecurityTokenRequest = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setValidateSecurityTokenRequest($validateSecurityTokenRequest);
    }
    /**
     * Get SecurityToken value
     * @return string|null
     */
    public function getSecurityToken()
    {
        return $this->SecurityToken;
    }
    /**
     * Set SecurityToken value
     * @param string $securityToken
     * @return \StructType\ValidateSecurityToken
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        $this->SecurityToken = $securityToken;
        return $this;
    }
    /**
     * Get ValidateSecurityTokenRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ValidateSecurityToken|null
     */
    public function getValidateSecurityTokenRequest()
    {
        return isset($this->ValidateSecurityTokenRequest) ? $this->ValidateSecurityTokenRequest : null;
    }
    /**
     * Set ValidateSecurityTokenRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ValidateSecurityToken $validateSecurityTokenRequest
     * @return \StructType\ValidateSecurityToken
     */
    public function setValidateSecurityTokenRequest(\StructType\ValidateSecurityToken $validateSecurityTokenRequest = null)
    {
        if (is_null($validateSecurityTokenRequest) || (is_array($validateSecurityTokenRequest) && empty($validateSecurityTokenRequest))) {
            unset($this->ValidateSecurityTokenRequest);
        } else {
            $this->ValidateSecurityTokenRequest = $validateSecurityTokenRequest;
        }
        return $this;
    }
}
