<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupDataResChannel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupDataResChannel
 * @subpackage Structs
 */
class GroupDataResChannel extends AbstractStructBase
{
    /**
     * The ResChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResChannel;
    /**
     * Constructor method for GroupDataResChannel
     * @uses GroupDataResChannel::setResChannel()
     * @param string $resChannel
     */
    public function __construct($resChannel = null)
    {
        $this
            ->setResChannel($resChannel);
    }
    /**
     * Get ResChannel value
     * @return string|null
     */
    public function getResChannel()
    {
        return $this->ResChannel;
    }
    /**
     * Set ResChannel value
     * @uses \EnumType\Enumerations_ReservationChannelTypes::valueIsValid()
     * @uses \EnumType\Enumerations_ReservationChannelTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resChannel
     * @return \StructType\GroupDataResChannel
     */
    public function setResChannel($resChannel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_ReservationChannelTypes::valueIsValid($resChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_ReservationChannelTypes', is_array($resChannel) ? implode(', ', $resChannel) : var_export($resChannel, true), implode(', ', \EnumType\Enumerations_ReservationChannelTypes::getValidValues())), __LINE__);
        }
        $this->ResChannel = $resChannel;
        return $this;
    }
}
