<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonLookupRequestType StructType
 * @subpackage Structs
 */
class PersonLookupRequestType extends AbstractStructBase
{
    /**
     * The CallContext
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: callctx:CallContext
     * @var \StructType\CallContextType
     */
    public $CallContext;
    /**
     * The AuthorityContext
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: autctx:AuthorityContext
     * @var \StructType\AuthorityContextType
     */
    public $AuthorityContext;
    /**
     * The InvocationContext
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: invctx:InvocationContext
     * @var \StructType\InvocationContextType
     */
    public $InvocationContext;
    /**
     * The PNR
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - ref: cpr:PNR
     * @var string
     */
    public $PNR;
    /**
     * Constructor method for PersonLookupRequestType
     * @uses PersonLookupRequestType::setCallContext()
     * @uses PersonLookupRequestType::setAuthorityContext()
     * @uses PersonLookupRequestType::setInvocationContext()
     * @uses PersonLookupRequestType::setPNR()
     * @param \StructType\CallContextType $callContext
     * @param \StructType\AuthorityContextType $authorityContext
     * @param \StructType\InvocationContextType $invocationContext
     * @param string $pNR
     */
    public function __construct(\StructType\CallContextType $callContext = null, \StructType\AuthorityContextType $authorityContext = null, \StructType\InvocationContextType $invocationContext = null, $pNR = null)
    {
        $this
            ->setCallContext($callContext)
            ->setAuthorityContext($authorityContext)
            ->setInvocationContext($invocationContext)
            ->setPNR($pNR);
    }
    /**
     * Get CallContext value
     * @return \StructType\CallContextType|null
     */
    public function getCallContext()
    {
        return $this->CallContext;
    }
    /**
     * Set CallContext value
     * @param \StructType\CallContextType $callContext
     * @return \StructType\PersonLookupRequestType
     */
    public function setCallContext(\StructType\CallContextType $callContext = null)
    {
        $this->CallContext = $callContext;
        return $this;
    }
    /**
     * Get AuthorityContext value
     * @return \StructType\AuthorityContextType|null
     */
    public function getAuthorityContext()
    {
        return $this->AuthorityContext;
    }
    /**
     * Set AuthorityContext value
     * @param \StructType\AuthorityContextType $authorityContext
     * @return \StructType\PersonLookupRequestType
     */
    public function setAuthorityContext(\StructType\AuthorityContextType $authorityContext = null)
    {
        $this->AuthorityContext = $authorityContext;
        return $this;
    }
    /**
     * Get InvocationContext value
     * @return \StructType\InvocationContextType|null
     */
    public function getInvocationContext()
    {
        return $this->InvocationContext;
    }
    /**
     * Set InvocationContext value
     * @param \StructType\InvocationContextType $invocationContext
     * @return \StructType\PersonLookupRequestType
     */
    public function setInvocationContext(\StructType\InvocationContextType $invocationContext = null)
    {
        $this->InvocationContext = $invocationContext;
        return $this;
    }
    /**
     * Get PNR value
     * @return string|null
     */
    public function getPNR()
    {
        return $this->PNR;
    }
    /**
     * Set PNR value
     * @param string $pNR
     * @return \StructType\PersonLookupRequestType
     */
    public function setPNR($pNR = null)
    {
        // validation for constraint: string
        if (!is_null($pNR) && !is_string($pNR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pNR, true), gettype($pNR)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($pNR) && mb_strlen($pNR) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($pNR)), __LINE__);
        }
        $this->PNR = $pNR;
        return $this;
    }
}
