<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for barnType StructType
 * @subpackage Structs
 */
class BarnType extends AbstractStructBase
{
    /**
     * The personnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $personnummer;
    /**
     * Constructor method for barnType
     * @uses BarnType::setPersonnummer()
     * @param string $personnummer
     */
    public function __construct($personnummer = null)
    {
        $this
            ->setPersonnummer($personnummer);
    }
    /**
     * Get personnummer value
     * @return string
     */
    public function getPersonnummer()
    {
        return $this->personnummer;
    }
    /**
     * Set personnummer value
     * @param string $personnummer
     * @return \StructType\BarnType
     */
    public function setPersonnummer($personnummer = null)
    {
        // validation for constraint: string
        if (!is_null($personnummer) && !is_string($personnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personnummer, true), gettype($personnummer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($personnummer) && mb_strlen($personnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($personnummer)), __LINE__);
        }
        $this->personnummer = $personnummer;
        return $this;
    }
}
