<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adresseType StructType
 * @subpackage Structs
 */
class AdresseType extends AbstractStructBase
{
    /**
     * The kommuneCvr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kommuneCvr;
    /**
     * The kommunekode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $kommunekode;
    /**
     * The vejkode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $vejkode;
    /**
     * The husnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $husnummer;
    /**
     * The etage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $etage;
    /**
     * The sidedoer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sidedoer;
    /**
     * The bygningsnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bygningsnummer;
    /**
     * The conavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $conavn;
    /**
     * The lokalitet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lokalitet;
    /**
     * The bynavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bynavn;
    /**
     * The postnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postnummer;
    /**
     * The postdistrikt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postdistrikt;
    /**
     * The vejnavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vejnavn;
    /**
     * The standardadresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $standardadresse;
    /**
     * The adresseringsnavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adresseringsnavn;
    /**
     * The vejadresseringsnavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vejadresseringsnavn;
    /**
     * The tilflytningsdato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UsikkerhedDatoTidType
     */
    public $tilflytningsdato;
    /**
     * The adr1_supladr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adr1_supladr;
    /**
     * The adr2_supladr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adr2_supladr;
    /**
     * The adr3_supladr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adr3_supladr;
    /**
     * The adr4_supladr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adr4_supladr;
    /**
     * The adr5_supladr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adr5_supladr;
    /**
     * The distrikter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DistrikterType
     */
    public $distrikter;
    /**
     * The AdresseUUID
     * Meta information extracted from the WSDL
     * - documentation: Unikt ID fra DAR som identificerer en adresse.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $AdresseUUID;
    /**
     * Constructor method for adresseType
     * @uses AdresseType::setKommuneCvr()
     * @uses AdresseType::setKommunekode()
     * @uses AdresseType::setVejkode()
     * @uses AdresseType::setHusnummer()
     * @uses AdresseType::setEtage()
     * @uses AdresseType::setSidedoer()
     * @uses AdresseType::setBygningsnummer()
     * @uses AdresseType::setConavn()
     * @uses AdresseType::setLokalitet()
     * @uses AdresseType::setBynavn()
     * @uses AdresseType::setPostnummer()
     * @uses AdresseType::setPostdistrikt()
     * @uses AdresseType::setVejnavn()
     * @uses AdresseType::setStandardadresse()
     * @uses AdresseType::setAdresseringsnavn()
     * @uses AdresseType::setVejadresseringsnavn()
     * @uses AdresseType::setTilflytningsdato()
     * @uses AdresseType::setAdr1_supladr()
     * @uses AdresseType::setAdr2_supladr()
     * @uses AdresseType::setAdr3_supladr()
     * @uses AdresseType::setAdr4_supladr()
     * @uses AdresseType::setAdr5_supladr()
     * @uses AdresseType::setDistrikter()
     * @uses AdresseType::setAdresseUUID()
     * @param string $kommuneCvr
     * @param int $kommunekode
     * @param int $vejkode
     * @param string $husnummer
     * @param string $etage
     * @param string $sidedoer
     * @param string $bygningsnummer
     * @param string $conavn
     * @param string $lokalitet
     * @param string $bynavn
     * @param string $postnummer
     * @param string $postdistrikt
     * @param string $vejnavn
     * @param string $standardadresse
     * @param string $adresseringsnavn
     * @param string $vejadresseringsnavn
     * @param \StructType\UsikkerhedDatoTidType $tilflytningsdato
     * @param string $adr1_supladr
     * @param string $adr2_supladr
     * @param string $adr3_supladr
     * @param string $adr4_supladr
     * @param string $adr5_supladr
     * @param \StructType\DistrikterType $distrikter
     * @param string $adresseUUID
     */
    public function __construct($kommuneCvr = null, $kommunekode = null, $vejkode = null, $husnummer = null, $etage = null, $sidedoer = null, $bygningsnummer = null, $conavn = null, $lokalitet = null, $bynavn = null, $postnummer = null, $postdistrikt = null, $vejnavn = null, $standardadresse = null, $adresseringsnavn = null, $vejadresseringsnavn = null, \StructType\UsikkerhedDatoTidType $tilflytningsdato = null, $adr1_supladr = null, $adr2_supladr = null, $adr3_supladr = null, $adr4_supladr = null, $adr5_supladr = null, \StructType\DistrikterType $distrikter = null, $adresseUUID = null)
    {
        $this
            ->setKommuneCvr($kommuneCvr)
            ->setKommunekode($kommunekode)
            ->setVejkode($vejkode)
            ->setHusnummer($husnummer)
            ->setEtage($etage)
            ->setSidedoer($sidedoer)
            ->setBygningsnummer($bygningsnummer)
            ->setConavn($conavn)
            ->setLokalitet($lokalitet)
            ->setBynavn($bynavn)
            ->setPostnummer($postnummer)
            ->setPostdistrikt($postdistrikt)
            ->setVejnavn($vejnavn)
            ->setStandardadresse($standardadresse)
            ->setAdresseringsnavn($adresseringsnavn)
            ->setVejadresseringsnavn($vejadresseringsnavn)
            ->setTilflytningsdato($tilflytningsdato)
            ->setAdr1_supladr($adr1_supladr)
            ->setAdr2_supladr($adr2_supladr)
            ->setAdr3_supladr($adr3_supladr)
            ->setAdr4_supladr($adr4_supladr)
            ->setAdr5_supladr($adr5_supladr)
            ->setDistrikter($distrikter)
            ->setAdresseUUID($adresseUUID);
    }
    /**
     * Get kommuneCvr value
     * @return string|null
     */
    public function getKommuneCvr()
    {
        return $this->kommuneCvr;
    }
    /**
     * Set kommuneCvr value
     * @param string $kommuneCvr
     * @return \StructType\AdresseType
     */
    public function setKommuneCvr($kommuneCvr = null)
    {
        // validation for constraint: string
        if (!is_null($kommuneCvr) && !is_string($kommuneCvr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kommuneCvr, true), gettype($kommuneCvr)), __LINE__);
        }
        $this->kommuneCvr = $kommuneCvr;
        return $this;
    }
    /**
     * Get kommunekode value
     * @return int|null
     */
    public function getKommunekode()
    {
        return $this->kommunekode;
    }
    /**
     * Set kommunekode value
     * @param int $kommunekode
     * @return \StructType\AdresseType
     */
    public function setKommunekode($kommunekode = null)
    {
        // validation for constraint: int
        if (!is_null($kommunekode) && !(is_int($kommunekode) || ctype_digit($kommunekode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kommunekode, true), gettype($kommunekode)), __LINE__);
        }
        $this->kommunekode = $kommunekode;
        return $this;
    }
    /**
     * Get vejkode value
     * @return int|null
     */
    public function getVejkode()
    {
        return $this->vejkode;
    }
    /**
     * Set vejkode value
     * @param int $vejkode
     * @return \StructType\AdresseType
     */
    public function setVejkode($vejkode = null)
    {
        // validation for constraint: int
        if (!is_null($vejkode) && !(is_int($vejkode) || ctype_digit($vejkode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vejkode, true), gettype($vejkode)), __LINE__);
        }
        $this->vejkode = $vejkode;
        return $this;
    }
    /**
     * Get husnummer value
     * @return string|null
     */
    public function getHusnummer()
    {
        return $this->husnummer;
    }
    /**
     * Set husnummer value
     * @param string $husnummer
     * @return \StructType\AdresseType
     */
    public function setHusnummer($husnummer = null)
    {
        // validation for constraint: string
        if (!is_null($husnummer) && !is_string($husnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($husnummer, true), gettype($husnummer)), __LINE__);
        }
        $this->husnummer = $husnummer;
        return $this;
    }
    /**
     * Get etage value
     * @return string|null
     */
    public function getEtage()
    {
        return $this->etage;
    }
    /**
     * Set etage value
     * @param string $etage
     * @return \StructType\AdresseType
     */
    public function setEtage($etage = null)
    {
        // validation for constraint: string
        if (!is_null($etage) && !is_string($etage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($etage, true), gettype($etage)), __LINE__);
        }
        $this->etage = $etage;
        return $this;
    }
    /**
     * Get sidedoer value
     * @return string|null
     */
    public function getSidedoer()
    {
        return $this->sidedoer;
    }
    /**
     * Set sidedoer value
     * @param string $sidedoer
     * @return \StructType\AdresseType
     */
    public function setSidedoer($sidedoer = null)
    {
        // validation for constraint: string
        if (!is_null($sidedoer) && !is_string($sidedoer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sidedoer, true), gettype($sidedoer)), __LINE__);
        }
        $this->sidedoer = $sidedoer;
        return $this;
    }
    /**
     * Get bygningsnummer value
     * @return string|null
     */
    public function getBygningsnummer()
    {
        return $this->bygningsnummer;
    }
    /**
     * Set bygningsnummer value
     * @param string $bygningsnummer
     * @return \StructType\AdresseType
     */
    public function setBygningsnummer($bygningsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($bygningsnummer) && !is_string($bygningsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bygningsnummer, true), gettype($bygningsnummer)), __LINE__);
        }
        $this->bygningsnummer = $bygningsnummer;
        return $this;
    }
    /**
     * Get conavn value
     * @return string|null
     */
    public function getConavn()
    {
        return $this->conavn;
    }
    /**
     * Set conavn value
     * @param string $conavn
     * @return \StructType\AdresseType
     */
    public function setConavn($conavn = null)
    {
        // validation for constraint: string
        if (!is_null($conavn) && !is_string($conavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conavn, true), gettype($conavn)), __LINE__);
        }
        $this->conavn = $conavn;
        return $this;
    }
    /**
     * Get lokalitet value
     * @return string|null
     */
    public function getLokalitet()
    {
        return $this->lokalitet;
    }
    /**
     * Set lokalitet value
     * @param string $lokalitet
     * @return \StructType\AdresseType
     */
    public function setLokalitet($lokalitet = null)
    {
        // validation for constraint: string
        if (!is_null($lokalitet) && !is_string($lokalitet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lokalitet, true), gettype($lokalitet)), __LINE__);
        }
        $this->lokalitet = $lokalitet;
        return $this;
    }
    /**
     * Get bynavn value
     * @return string|null
     */
    public function getBynavn()
    {
        return $this->bynavn;
    }
    /**
     * Set bynavn value
     * @param string $bynavn
     * @return \StructType\AdresseType
     */
    public function setBynavn($bynavn = null)
    {
        // validation for constraint: string
        if (!is_null($bynavn) && !is_string($bynavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bynavn, true), gettype($bynavn)), __LINE__);
        }
        $this->bynavn = $bynavn;
        return $this;
    }
    /**
     * Get postnummer value
     * @return string|null
     */
    public function getPostnummer()
    {
        return $this->postnummer;
    }
    /**
     * Set postnummer value
     * @param string $postnummer
     * @return \StructType\AdresseType
     */
    public function setPostnummer($postnummer = null)
    {
        // validation for constraint: string
        if (!is_null($postnummer) && !is_string($postnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postnummer, true), gettype($postnummer)), __LINE__);
        }
        $this->postnummer = $postnummer;
        return $this;
    }
    /**
     * Get postdistrikt value
     * @return string|null
     */
    public function getPostdistrikt()
    {
        return $this->postdistrikt;
    }
    /**
     * Set postdistrikt value
     * @param string $postdistrikt
     * @return \StructType\AdresseType
     */
    public function setPostdistrikt($postdistrikt = null)
    {
        // validation for constraint: string
        if (!is_null($postdistrikt) && !is_string($postdistrikt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postdistrikt, true), gettype($postdistrikt)), __LINE__);
        }
        $this->postdistrikt = $postdistrikt;
        return $this;
    }
    /**
     * Get vejnavn value
     * @return string|null
     */
    public function getVejnavn()
    {
        return $this->vejnavn;
    }
    /**
     * Set vejnavn value
     * @param string $vejnavn
     * @return \StructType\AdresseType
     */
    public function setVejnavn($vejnavn = null)
    {
        // validation for constraint: string
        if (!is_null($vejnavn) && !is_string($vejnavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vejnavn, true), gettype($vejnavn)), __LINE__);
        }
        $this->vejnavn = $vejnavn;
        return $this;
    }
    /**
     * Get standardadresse value
     * @return string|null
     */
    public function getStandardadresse()
    {
        return $this->standardadresse;
    }
    /**
     * Set standardadresse value
     * @param string $standardadresse
     * @return \StructType\AdresseType
     */
    public function setStandardadresse($standardadresse = null)
    {
        // validation for constraint: string
        if (!is_null($standardadresse) && !is_string($standardadresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standardadresse, true), gettype($standardadresse)), __LINE__);
        }
        $this->standardadresse = $standardadresse;
        return $this;
    }
    /**
     * Get adresseringsnavn value
     * @return string|null
     */
    public function getAdresseringsnavn()
    {
        return $this->adresseringsnavn;
    }
    /**
     * Set adresseringsnavn value
     * @param string $adresseringsnavn
     * @return \StructType\AdresseType
     */
    public function setAdresseringsnavn($adresseringsnavn = null)
    {
        // validation for constraint: string
        if (!is_null($adresseringsnavn) && !is_string($adresseringsnavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresseringsnavn, true), gettype($adresseringsnavn)), __LINE__);
        }
        $this->adresseringsnavn = $adresseringsnavn;
        return $this;
    }
    /**
     * Get vejadresseringsnavn value
     * @return string|null
     */
    public function getVejadresseringsnavn()
    {
        return $this->vejadresseringsnavn;
    }
    /**
     * Set vejadresseringsnavn value
     * @param string $vejadresseringsnavn
     * @return \StructType\AdresseType
     */
    public function setVejadresseringsnavn($vejadresseringsnavn = null)
    {
        // validation for constraint: string
        if (!is_null($vejadresseringsnavn) && !is_string($vejadresseringsnavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vejadresseringsnavn, true), gettype($vejadresseringsnavn)), __LINE__);
        }
        $this->vejadresseringsnavn = $vejadresseringsnavn;
        return $this;
    }
    /**
     * Get tilflytningsdato value
     * @return \StructType\UsikkerhedDatoTidType|null
     */
    public function getTilflytningsdato()
    {
        return $this->tilflytningsdato;
    }
    /**
     * Set tilflytningsdato value
     * @param \StructType\UsikkerhedDatoTidType $tilflytningsdato
     * @return \StructType\AdresseType
     */
    public function setTilflytningsdato(\StructType\UsikkerhedDatoTidType $tilflytningsdato = null)
    {
        $this->tilflytningsdato = $tilflytningsdato;
        return $this;
    }
    /**
     * Get adr1_supladr value
     * @return string|null
     */
    public function getAdr1_supladr()
    {
        return $this->{'adr1-supladr'};
    }
    /**
     * Set adr1_supladr value
     * @param string $adr1_supladr
     * @return \StructType\AdresseType
     */
    public function setAdr1_supladr($adr1_supladr = null)
    {
        // validation for constraint: string
        if (!is_null($adr1_supladr) && !is_string($adr1_supladr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr1_supladr, true), gettype($adr1_supladr)), __LINE__);
        }
        $this->adr1_supladr = $this->{'adr1-supladr'} = $adr1_supladr;
        return $this;
    }
    /**
     * Get adr2_supladr value
     * @return string|null
     */
    public function getAdr2_supladr()
    {
        return $this->{'adr2-supladr'};
    }
    /**
     * Set adr2_supladr value
     * @param string $adr2_supladr
     * @return \StructType\AdresseType
     */
    public function setAdr2_supladr($adr2_supladr = null)
    {
        // validation for constraint: string
        if (!is_null($adr2_supladr) && !is_string($adr2_supladr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr2_supladr, true), gettype($adr2_supladr)), __LINE__);
        }
        $this->adr2_supladr = $this->{'adr2-supladr'} = $adr2_supladr;
        return $this;
    }
    /**
     * Get adr3_supladr value
     * @return string|null
     */
    public function getAdr3_supladr()
    {
        return $this->{'adr3-supladr'};
    }
    /**
     * Set adr3_supladr value
     * @param string $adr3_supladr
     * @return \StructType\AdresseType
     */
    public function setAdr3_supladr($adr3_supladr = null)
    {
        // validation for constraint: string
        if (!is_null($adr3_supladr) && !is_string($adr3_supladr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr3_supladr, true), gettype($adr3_supladr)), __LINE__);
        }
        $this->adr3_supladr = $this->{'adr3-supladr'} = $adr3_supladr;
        return $this;
    }
    /**
     * Get adr4_supladr value
     * @return string|null
     */
    public function getAdr4_supladr()
    {
        return $this->{'adr4-supladr'};
    }
    /**
     * Set adr4_supladr value
     * @param string $adr4_supladr
     * @return \StructType\AdresseType
     */
    public function setAdr4_supladr($adr4_supladr = null)
    {
        // validation for constraint: string
        if (!is_null($adr4_supladr) && !is_string($adr4_supladr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr4_supladr, true), gettype($adr4_supladr)), __LINE__);
        }
        $this->adr4_supladr = $this->{'adr4-supladr'} = $adr4_supladr;
        return $this;
    }
    /**
     * Get adr5_supladr value
     * @return string|null
     */
    public function getAdr5_supladr()
    {
        return $this->{'adr5-supladr'};
    }
    /**
     * Set adr5_supladr value
     * @param string $adr5_supladr
     * @return \StructType\AdresseType
     */
    public function setAdr5_supladr($adr5_supladr = null)
    {
        // validation for constraint: string
        if (!is_null($adr5_supladr) && !is_string($adr5_supladr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr5_supladr, true), gettype($adr5_supladr)), __LINE__);
        }
        $this->adr5_supladr = $this->{'adr5-supladr'} = $adr5_supladr;
        return $this;
    }
    /**
     * Get distrikter value
     * @return \StructType\DistrikterType|null
     */
    public function getDistrikter()
    {
        return $this->distrikter;
    }
    /**
     * Set distrikter value
     * @param \StructType\DistrikterType $distrikter
     * @return \StructType\AdresseType
     */
    public function setDistrikter(\StructType\DistrikterType $distrikter = null)
    {
        $this->distrikter = $distrikter;
        return $this;
    }
    /**
     * Get AdresseUUID value
     * @return string|null
     */
    public function getAdresseUUID()
    {
        return $this->AdresseUUID;
    }
    /**
     * Set AdresseUUID value
     * @param string $adresseUUID
     * @return \StructType\AdresseType
     */
    public function setAdresseUUID($adresseUUID = null)
    {
        // validation for constraint: string
        if (!is_null($adresseUUID) && !is_string($adresseUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresseUUID, true), gettype($adresseUUID)), __LINE__);
        }
        // validation for constraint: pattern([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})
        if (!is_null($adresseUUID) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $adresseUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', var_export($adresseUUID, true)), __LINE__);
        }
        $this->AdresseUUID = $adresseUUID;
        return $this;
    }
}
