<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for persondataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The field 'alder' is calculated as the time from 'foedselsdato' to the time of asking, without regard to the 'status' of the person. The age of the child is calculated as the time from its birthday (calculated based on 'pnr') to the
 * time of asking, without regard to the 'status' of the child. The field 'antalboernunder18' includes only active children (status: 1, 3, 5 and 7)
 * @subpackage Structs
 */
class PersondataType extends AbstractStructBase
{
    /**
     * The antalBoernUnder18
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $antalBoernUnder18;
    /**
     * The personnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $personnummer;
    /**
     * The gaeldendePersonnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gaeldendePersonnummer;
    /**
     * The navn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NavnType
     */
    public $navn;
    /**
     * The foedselsdato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UsikkerhedDatoType
     */
    public $foedselsdato;
    /**
     * The foedselsregistreringsOplysninger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FoedselsregistreringOplysningerType
     */
    public $foedselsregistreringsOplysninger;
    /**
     * The startdato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UsikkerhedDatoType
     */
    public $startdato;
    /**
     * The slutdato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UsikkerhedDatoType
     */
    public $slutdato;
    /**
     * The alder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $alder;
    /**
     * The koen
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $koen;
    /**
     * The stilling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $stilling;
    /**
     * The DeltBopælMarkering
     * Meta information extracted from the WSDL
     * - documentation: Markering for Delt bopæl når forældre viser, der har fælles forældremyndighed, har aftalt, at barnet har delt bopæl.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DeltBopælMarkering;
    /**
     * The DeltBopælStartDato
     * Meta information extracted from the WSDL
     * - documentation: Startdato for delt bopæl, når der markeres ja til delt bopæl.
     * - base: xsd:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeltBopælStartDato;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatusType
     */
    public $status;
    /**
     * The separation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SeparationType
     */
    public $separation;
    /**
     * The civilstand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CivilstandType
     */
    public $civilstand;
    /**
     * The statsborgerskab
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StatsborgerskabType
     */
    public $statsborgerskab;
    /**
     * The umyndiggoerelse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UmyndiggoerelseType
     */
    public $umyndiggoerelse;
    /**
     * The forsvindingsdato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UsikkerhedDatoTidType
     */
    public $forsvindingsdato;
    /**
     * The adressebeskyttelse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BeskyttelseType
     */
    public $adressebeskyttelse;
    /**
     * The vejviserbeskyttelse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BeskyttelseType
     */
    public $vejviserbeskyttelse;
    /**
     * The markedsfoeringsbeskyttelse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BeskyttelseType
     */
    public $markedsfoeringsbeskyttelse;
    /**
     * The tilmeldtNemsms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $tilmeldtNemsms;
    /**
     * The tilmeldtDigitalpost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $tilmeldtDigitalpost;
    /**
     * Constructor method for persondataType
     * @uses PersondataType::setAntalBoernUnder18()
     * @uses PersondataType::setPersonnummer()
     * @uses PersondataType::setGaeldendePersonnummer()
     * @uses PersondataType::setNavn()
     * @uses PersondataType::setFoedselsdato()
     * @uses PersondataType::setFoedselsregistreringsOplysninger()
     * @uses PersondataType::setStartdato()
     * @uses PersondataType::setSlutdato()
     * @uses PersondataType::setAlder()
     * @uses PersondataType::setKoen()
     * @uses PersondataType::setStilling()
     * @uses PersondataType::setDeltBopælMarkering()
     * @uses PersondataType::setDeltBopælStartDato()
     * @uses PersondataType::setStatus()
     * @uses PersondataType::setSeparation()
     * @uses PersondataType::setCivilstand()
     * @uses PersondataType::setStatsborgerskab()
     * @uses PersondataType::setUmyndiggoerelse()
     * @uses PersondataType::setForsvindingsdato()
     * @uses PersondataType::setAdressebeskyttelse()
     * @uses PersondataType::setVejviserbeskyttelse()
     * @uses PersondataType::setMarkedsfoeringsbeskyttelse()
     * @uses PersondataType::setTilmeldtNemsms()
     * @uses PersondataType::setTilmeldtDigitalpost()
     * @param int $antalBoernUnder18
     * @param string $personnummer
     * @param string $gaeldendePersonnummer
     * @param \StructType\NavnType $navn
     * @param \StructType\UsikkerhedDatoType $foedselsdato
     * @param \StructType\FoedselsregistreringOplysningerType $foedselsregistreringsOplysninger
     * @param \StructType\UsikkerhedDatoType $startdato
     * @param \StructType\UsikkerhedDatoType $slutdato
     * @param int $alder
     * @param string $koen
     * @param string $stilling
     * @param bool $deltBopælMarkering
     * @param string $deltBopælStartDato
     * @param \StructType\StatusType $status
     * @param \StructType\SeparationType $separation
     * @param \StructType\CivilstandType $civilstand
     * @param \StructType\StatsborgerskabType $statsborgerskab
     * @param \StructType\UmyndiggoerelseType $umyndiggoerelse
     * @param \StructType\UsikkerhedDatoTidType $forsvindingsdato
     * @param \StructType\BeskyttelseType $adressebeskyttelse
     * @param \StructType\BeskyttelseType $vejviserbeskyttelse
     * @param \StructType\BeskyttelseType $markedsfoeringsbeskyttelse
     * @param bool $tilmeldtNemsms
     * @param bool $tilmeldtDigitalpost
     */
    public function __construct($antalBoernUnder18 = null, $personnummer = null, $gaeldendePersonnummer = null, \StructType\NavnType $navn = null, \StructType\UsikkerhedDatoType $foedselsdato = null, \StructType\FoedselsregistreringOplysningerType $foedselsregistreringsOplysninger = null, \StructType\UsikkerhedDatoType $startdato = null, \StructType\UsikkerhedDatoType $slutdato = null, $alder = null, $koen = null, $stilling = null, $deltBopælMarkering = null, $deltBopælStartDato = null, \StructType\StatusType $status = null, \StructType\SeparationType $separation = null, \StructType\CivilstandType $civilstand = null, \StructType\StatsborgerskabType $statsborgerskab = null, \StructType\UmyndiggoerelseType $umyndiggoerelse = null, \StructType\UsikkerhedDatoTidType $forsvindingsdato = null, \StructType\BeskyttelseType $adressebeskyttelse = null, \StructType\BeskyttelseType $vejviserbeskyttelse = null, \StructType\BeskyttelseType $markedsfoeringsbeskyttelse = null, $tilmeldtNemsms = null, $tilmeldtDigitalpost = null)
    {
        $this
            ->setAntalBoernUnder18($antalBoernUnder18)
            ->setPersonnummer($personnummer)
            ->setGaeldendePersonnummer($gaeldendePersonnummer)
            ->setNavn($navn)
            ->setFoedselsdato($foedselsdato)
            ->setFoedselsregistreringsOplysninger($foedselsregistreringsOplysninger)
            ->setStartdato($startdato)
            ->setSlutdato($slutdato)
            ->setAlder($alder)
            ->setKoen($koen)
            ->setStilling($stilling)
            ->setDeltBopælMarkering($deltBopælMarkering)
            ->setDeltBopælStartDato($deltBopælStartDato)
            ->setStatus($status)
            ->setSeparation($separation)
            ->setCivilstand($civilstand)
            ->setStatsborgerskab($statsborgerskab)
            ->setUmyndiggoerelse($umyndiggoerelse)
            ->setForsvindingsdato($forsvindingsdato)
            ->setAdressebeskyttelse($adressebeskyttelse)
            ->setVejviserbeskyttelse($vejviserbeskyttelse)
            ->setMarkedsfoeringsbeskyttelse($markedsfoeringsbeskyttelse)
            ->setTilmeldtNemsms($tilmeldtNemsms)
            ->setTilmeldtDigitalpost($tilmeldtDigitalpost);
    }
    /**
     * Get antalBoernUnder18 value
     * @return int
     */
    public function getAntalBoernUnder18()
    {
        return $this->antalBoernUnder18;
    }
    /**
     * Set antalBoernUnder18 value
     * @param int $antalBoernUnder18
     * @return \StructType\PersondataType
     */
    public function setAntalBoernUnder18($antalBoernUnder18 = null)
    {
        // validation for constraint: int
        if (!is_null($antalBoernUnder18) && !(is_int($antalBoernUnder18) || ctype_digit($antalBoernUnder18))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($antalBoernUnder18, true), gettype($antalBoernUnder18)), __LINE__);
        }
        $this->antalBoernUnder18 = $antalBoernUnder18;
        return $this;
    }
    /**
     * Get personnummer value
     * @return string|null
     */
    public function getPersonnummer()
    {
        return $this->personnummer;
    }
    /**
     * Set personnummer value
     * @param string $personnummer
     * @return \StructType\PersondataType
     */
    public function setPersonnummer($personnummer = null)
    {
        // validation for constraint: string
        if (!is_null($personnummer) && !is_string($personnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personnummer, true), gettype($personnummer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($personnummer) && mb_strlen($personnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($personnummer)), __LINE__);
        }
        $this->personnummer = $personnummer;
        return $this;
    }
    /**
     * Get gaeldendePersonnummer value
     * @return string|null
     */
    public function getGaeldendePersonnummer()
    {
        return $this->gaeldendePersonnummer;
    }
    /**
     * Set gaeldendePersonnummer value
     * @param string $gaeldendePersonnummer
     * @return \StructType\PersondataType
     */
    public function setGaeldendePersonnummer($gaeldendePersonnummer = null)
    {
        // validation for constraint: string
        if (!is_null($gaeldendePersonnummer) && !is_string($gaeldendePersonnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gaeldendePersonnummer, true), gettype($gaeldendePersonnummer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($gaeldendePersonnummer) && mb_strlen($gaeldendePersonnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($gaeldendePersonnummer)), __LINE__);
        }
        $this->gaeldendePersonnummer = $gaeldendePersonnummer;
        return $this;
    }
    /**
     * Get navn value
     * @return \StructType\NavnType|null
     */
    public function getNavn()
    {
        return $this->navn;
    }
    /**
     * Set navn value
     * @param \StructType\NavnType $navn
     * @return \StructType\PersondataType
     */
    public function setNavn(\StructType\NavnType $navn = null)
    {
        $this->navn = $navn;
        return $this;
    }
    /**
     * Get foedselsdato value
     * @return \StructType\UsikkerhedDatoType|null
     */
    public function getFoedselsdato()
    {
        return $this->foedselsdato;
    }
    /**
     * Set foedselsdato value
     * @param \StructType\UsikkerhedDatoType $foedselsdato
     * @return \StructType\PersondataType
     */
    public function setFoedselsdato(\StructType\UsikkerhedDatoType $foedselsdato = null)
    {
        $this->foedselsdato = $foedselsdato;
        return $this;
    }
    /**
     * Get foedselsregistreringsOplysninger value
     * @return \StructType\FoedselsregistreringOplysningerType|null
     */
    public function getFoedselsregistreringsOplysninger()
    {
        return $this->foedselsregistreringsOplysninger;
    }
    /**
     * Set foedselsregistreringsOplysninger value
     * @param \StructType\FoedselsregistreringOplysningerType $foedselsregistreringsOplysninger
     * @return \StructType\PersondataType
     */
    public function setFoedselsregistreringsOplysninger(\StructType\FoedselsregistreringOplysningerType $foedselsregistreringsOplysninger = null)
    {
        $this->foedselsregistreringsOplysninger = $foedselsregistreringsOplysninger;
        return $this;
    }
    /**
     * Get startdato value
     * @return \StructType\UsikkerhedDatoType|null
     */
    public function getStartdato()
    {
        return $this->startdato;
    }
    /**
     * Set startdato value
     * @param \StructType\UsikkerhedDatoType $startdato
     * @return \StructType\PersondataType
     */
    public function setStartdato(\StructType\UsikkerhedDatoType $startdato = null)
    {
        $this->startdato = $startdato;
        return $this;
    }
    /**
     * Get slutdato value
     * @return \StructType\UsikkerhedDatoType|null
     */
    public function getSlutdato()
    {
        return $this->slutdato;
    }
    /**
     * Set slutdato value
     * @param \StructType\UsikkerhedDatoType $slutdato
     * @return \StructType\PersondataType
     */
    public function setSlutdato(\StructType\UsikkerhedDatoType $slutdato = null)
    {
        $this->slutdato = $slutdato;
        return $this;
    }
    /**
     * Get alder value
     * @return int|null
     */
    public function getAlder()
    {
        return $this->alder;
    }
    /**
     * Set alder value
     * @param int $alder
     * @return \StructType\PersondataType
     */
    public function setAlder($alder = null)
    {
        // validation for constraint: int
        if (!is_null($alder) && !(is_int($alder) || ctype_digit($alder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alder, true), gettype($alder)), __LINE__);
        }
        $this->alder = $alder;
        return $this;
    }
    /**
     * Get koen value
     * @return string|null
     */
    public function getKoen()
    {
        return $this->koen;
    }
    /**
     * Set koen value
     * @uses \EnumType\KoenType::valueIsValid()
     * @uses \EnumType\KoenType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $koen
     * @return \StructType\PersondataType
     */
    public function setKoen($koen = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KoenType::valueIsValid($koen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KoenType', is_array($koen) ? implode(', ', $koen) : var_export($koen, true), implode(', ', \EnumType\KoenType::getValidValues())), __LINE__);
        }
        $this->koen = $koen;
        return $this;
    }
    /**
     * Get stilling value
     * @return string|null
     */
    public function getStilling()
    {
        return $this->stilling;
    }
    /**
     * Set stilling value
     * @param string $stilling
     * @return \StructType\PersondataType
     */
    public function setStilling($stilling = null)
    {
        // validation for constraint: string
        if (!is_null($stilling) && !is_string($stilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stilling, true), gettype($stilling)), __LINE__);
        }
        $this->stilling = $stilling;
        return $this;
    }
    /**
     * Get DeltBopælMarkering value
     * @return bool|null
     */
    public function getDeltBopælMarkering()
    {
        return $this->DeltBopælMarkering;
    }
    /**
     * Set DeltBopælMarkering value
     * @param bool $deltBopælMarkering
     * @return \StructType\PersondataType
     */
    public function setDeltBopælMarkering($deltBopælMarkering = null)
    {
        // validation for constraint: boolean
        if (!is_null($deltBopælMarkering) && !is_bool($deltBopælMarkering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deltBopælMarkering, true), gettype($deltBopælMarkering)), __LINE__);
        }
        $this->DeltBopælMarkering = $deltBopælMarkering;
        return $this;
    }
    /**
     * Get DeltBopælStartDato value
     * @return string|null
     */
    public function getDeltBopælStartDato()
    {
        return $this->DeltBopælStartDato;
    }
    /**
     * Set DeltBopælStartDato value
     * @param string $deltBopælStartDato
     * @return \StructType\PersondataType
     */
    public function setDeltBopælStartDato($deltBopælStartDato = null)
    {
        // validation for constraint: string
        if (!is_null($deltBopælStartDato) && !is_string($deltBopælStartDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deltBopælStartDato, true), gettype($deltBopælStartDato)), __LINE__);
        }
        $this->DeltBopælStartDato = $deltBopælStartDato;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\StatusType|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\StatusType $status
     * @return \StructType\PersondataType
     */
    public function setStatus(\StructType\StatusType $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get separation value
     * @return \StructType\SeparationType|null
     */
    public function getSeparation()
    {
        return $this->separation;
    }
    /**
     * Set separation value
     * @param \StructType\SeparationType $separation
     * @return \StructType\PersondataType
     */
    public function setSeparation(\StructType\SeparationType $separation = null)
    {
        $this->separation = $separation;
        return $this;
    }
    /**
     * Get civilstand value
     * @return \StructType\CivilstandType|null
     */
    public function getCivilstand()
    {
        return $this->civilstand;
    }
    /**
     * Set civilstand value
     * @param \StructType\CivilstandType $civilstand
     * @return \StructType\PersondataType
     */
    public function setCivilstand(\StructType\CivilstandType $civilstand = null)
    {
        $this->civilstand = $civilstand;
        return $this;
    }
    /**
     * Get statsborgerskab value
     * @return \StructType\StatsborgerskabType|null
     */
    public function getStatsborgerskab()
    {
        return $this->statsborgerskab;
    }
    /**
     * Set statsborgerskab value
     * @param \StructType\StatsborgerskabType $statsborgerskab
     * @return \StructType\PersondataType
     */
    public function setStatsborgerskab(\StructType\StatsborgerskabType $statsborgerskab = null)
    {
        $this->statsborgerskab = $statsborgerskab;
        return $this;
    }
    /**
     * Get umyndiggoerelse value
     * @return \StructType\UmyndiggoerelseType|null
     */
    public function getUmyndiggoerelse()
    {
        return $this->umyndiggoerelse;
    }
    /**
     * Set umyndiggoerelse value
     * @param \StructType\UmyndiggoerelseType $umyndiggoerelse
     * @return \StructType\PersondataType
     */
    public function setUmyndiggoerelse(\StructType\UmyndiggoerelseType $umyndiggoerelse = null)
    {
        $this->umyndiggoerelse = $umyndiggoerelse;
        return $this;
    }
    /**
     * Get forsvindingsdato value
     * @return \StructType\UsikkerhedDatoTidType|null
     */
    public function getForsvindingsdato()
    {
        return $this->forsvindingsdato;
    }
    /**
     * Set forsvindingsdato value
     * @param \StructType\UsikkerhedDatoTidType $forsvindingsdato
     * @return \StructType\PersondataType
     */
    public function setForsvindingsdato(\StructType\UsikkerhedDatoTidType $forsvindingsdato = null)
    {
        $this->forsvindingsdato = $forsvindingsdato;
        return $this;
    }
    /**
     * Get adressebeskyttelse value
     * @return \StructType\BeskyttelseType|null
     */
    public function getAdressebeskyttelse()
    {
        return $this->adressebeskyttelse;
    }
    /**
     * Set adressebeskyttelse value
     * @param \StructType\BeskyttelseType $adressebeskyttelse
     * @return \StructType\PersondataType
     */
    public function setAdressebeskyttelse(\StructType\BeskyttelseType $adressebeskyttelse = null)
    {
        $this->adressebeskyttelse = $adressebeskyttelse;
        return $this;
    }
    /**
     * Get vejviserbeskyttelse value
     * @return \StructType\BeskyttelseType|null
     */
    public function getVejviserbeskyttelse()
    {
        return $this->vejviserbeskyttelse;
    }
    /**
     * Set vejviserbeskyttelse value
     * @param \StructType\BeskyttelseType $vejviserbeskyttelse
     * @return \StructType\PersondataType
     */
    public function setVejviserbeskyttelse(\StructType\BeskyttelseType $vejviserbeskyttelse = null)
    {
        $this->vejviserbeskyttelse = $vejviserbeskyttelse;
        return $this;
    }
    /**
     * Get markedsfoeringsbeskyttelse value
     * @return \StructType\BeskyttelseType|null
     */
    public function getMarkedsfoeringsbeskyttelse()
    {
        return $this->markedsfoeringsbeskyttelse;
    }
    /**
     * Set markedsfoeringsbeskyttelse value
     * @param \StructType\BeskyttelseType $markedsfoeringsbeskyttelse
     * @return \StructType\PersondataType
     */
    public function setMarkedsfoeringsbeskyttelse(\StructType\BeskyttelseType $markedsfoeringsbeskyttelse = null)
    {
        $this->markedsfoeringsbeskyttelse = $markedsfoeringsbeskyttelse;
        return $this;
    }
    /**
     * Get tilmeldtNemsms value
     * @return bool|null
     */
    public function getTilmeldtNemsms()
    {
        return $this->tilmeldtNemsms;
    }
    /**
     * Set tilmeldtNemsms value
     * @param bool $tilmeldtNemsms
     * @return \StructType\PersondataType
     */
    public function setTilmeldtNemsms($tilmeldtNemsms = null)
    {
        // validation for constraint: boolean
        if (!is_null($tilmeldtNemsms) && !is_bool($tilmeldtNemsms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tilmeldtNemsms, true), gettype($tilmeldtNemsms)), __LINE__);
        }
        $this->tilmeldtNemsms = $tilmeldtNemsms;
        return $this;
    }
    /**
     * Get tilmeldtDigitalpost value
     * @return bool|null
     */
    public function getTilmeldtDigitalpost()
    {
        return $this->tilmeldtDigitalpost;
    }
    /**
     * Set tilmeldtDigitalpost value
     * @param bool $tilmeldtDigitalpost
     * @return \StructType\PersondataType
     */
    public function setTilmeldtDigitalpost($tilmeldtDigitalpost = null)
    {
        // validation for constraint: boolean
        if (!is_null($tilmeldtDigitalpost) && !is_bool($tilmeldtDigitalpost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tilmeldtDigitalpost, true), gettype($tilmeldtDigitalpost)), __LINE__);
        }
        $this->tilmeldtDigitalpost = $tilmeldtDigitalpost;
        return $this;
    }
}
