<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personRelationType StructType
 * @subpackage Structs
 */
class PersonRelationType extends AbstractStructBase
{
    /**
     * The personnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: personnummer | foedselsdato | navn
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 10
     * @var string
     */
    public $personnummer;
    /**
     * The foedselsdato
     * Meta information extracted from the WSDL
     * - choice: personnummer | foedselsdato | navn
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UsikkerhedDatoType
     */
    public $foedselsdato;
    /**
     * The navn
     * Meta information extracted from the WSDL
     * - choice: personnummer | foedselsdato | navn
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $navn;
    /**
     * Constructor method for personRelationType
     * @uses PersonRelationType::setPersonnummer()
     * @uses PersonRelationType::setFoedselsdato()
     * @uses PersonRelationType::setNavn()
     * @param string $personnummer
     * @param \StructType\UsikkerhedDatoType $foedselsdato
     * @param string $navn
     */
    public function __construct($personnummer = null, \StructType\UsikkerhedDatoType $foedselsdato = null, $navn = null)
    {
        $this
            ->setPersonnummer($personnummer)
            ->setFoedselsdato($foedselsdato)
            ->setNavn($navn);
    }
    /**
     * Get personnummer value
     * @return string|null
     */
    public function getPersonnummer()
    {
        return isset($this->personnummer) ? $this->personnummer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonnummer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonnummer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonnummerForChoiceConstraintsFromSetPersonnummer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'foedselsdato',
            'navn',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property personnummer can\'t be set as the property %s is already set. Only one property must be set among these properties: personnummer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set personnummer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $personnummer
     * @return \StructType\PersonRelationType
     */
    public function setPersonnummer($personnummer = null)
    {
        // validation for constraint: string
        if (!is_null($personnummer) && !is_string($personnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personnummer, true), gettype($personnummer)), __LINE__);
        }
        // validation for constraint: choice(personnummer, foedselsdato, navn)
        if ('' !== ($personnummerChoiceErrorMessage = self::validatePersonnummerForChoiceConstraintsFromSetPersonnummer($personnummer))) {
            throw new \InvalidArgumentException($personnummerChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($personnummer) && mb_strlen($personnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($personnummer)), __LINE__);
        }
        if (is_null($personnummer) || (is_array($personnummer) && empty($personnummer))) {
            unset($this->personnummer);
        } else {
            $this->personnummer = $personnummer;
        }
        return $this;
    }
    /**
     * Get foedselsdato value
     * @return \StructType\UsikkerhedDatoType|null
     */
    public function getFoedselsdato()
    {
        return isset($this->foedselsdato) ? $this->foedselsdato : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFoedselsdato method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFoedselsdato method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFoedselsdatoForChoiceConstraintsFromSetFoedselsdato($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'personnummer',
            'navn',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property foedselsdato can\'t be set as the property %s is already set. Only one property must be set among these properties: foedselsdato, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set foedselsdato value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UsikkerhedDatoType $foedselsdato
     * @return \StructType\PersonRelationType
     */
    public function setFoedselsdato(\StructType\UsikkerhedDatoType $foedselsdato = null)
    {
        // validation for constraint: choice(personnummer, foedselsdato, navn)
        if ('' !== ($foedselsdatoChoiceErrorMessage = self::validateFoedselsdatoForChoiceConstraintsFromSetFoedselsdato($foedselsdato))) {
            throw new \InvalidArgumentException($foedselsdatoChoiceErrorMessage, __LINE__);
        }
        if (is_null($foedselsdato) || (is_array($foedselsdato) && empty($foedselsdato))) {
            unset($this->foedselsdato);
        } else {
            $this->foedselsdato = $foedselsdato;
        }
        return $this;
    }
    /**
     * Get navn value
     * @return string|null
     */
    public function getNavn()
    {
        return isset($this->navn) ? $this->navn : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNavn method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNavn method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNavnForChoiceConstraintsFromSetNavn($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'personnummer',
            'foedselsdato',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property navn can\'t be set as the property %s is already set. Only one property must be set among these properties: navn, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set navn value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $navn
     * @return \StructType\PersonRelationType
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($navn, true), gettype($navn)), __LINE__);
        }
        // validation for constraint: choice(personnummer, foedselsdato, navn)
        if ('' !== ($navnChoiceErrorMessage = self::validateNavnForChoiceConstraintsFromSetNavn($navn))) {
            throw new \InvalidArgumentException($navnChoiceErrorMessage, __LINE__);
        }
        if (is_null($navn) || (is_array($navn) && empty($navn))) {
            unset($this->navn);
        } else {
            $this->navn = $navn;
        }
        return $this;
    }
}
