<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonLookupResponseType StructType
 * @subpackage Structs
 */
class PersonLookupResponseType extends AbstractStructBase
{
    /**
     * The persondata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersondataType
     */
    public $persondata;
    /**
     * The adresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdressedataType
     */
    public $adresse;
    /**
     * The relationer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelationerType
     */
    public $relationer;
    /**
     * The notater
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NotatType[]
     */
    public $notater;
    /**
     * Constructor method for PersonLookupResponseType
     * @uses PersonLookupResponseType::setPersondata()
     * @uses PersonLookupResponseType::setAdresse()
     * @uses PersonLookupResponseType::setRelationer()
     * @uses PersonLookupResponseType::setNotater()
     * @param \StructType\PersondataType $persondata
     * @param \StructType\AdressedataType $adresse
     * @param \StructType\RelationerType $relationer
     * @param \StructType\NotatType[] $notater
     */
    public function __construct(\StructType\PersondataType $persondata = null, \StructType\AdressedataType $adresse = null, \StructType\RelationerType $relationer = null, array $notater = array())
    {
        $this
            ->setPersondata($persondata)
            ->setAdresse($adresse)
            ->setRelationer($relationer)
            ->setNotater($notater);
    }
    /**
     * Get persondata value
     * @return \StructType\PersondataType|null
     */
    public function getPersondata()
    {
        return $this->persondata;
    }
    /**
     * Set persondata value
     * @param \StructType\PersondataType $persondata
     * @return \StructType\PersonLookupResponseType
     */
    public function setPersondata(\StructType\PersondataType $persondata = null)
    {
        $this->persondata = $persondata;
        return $this;
    }
    /**
     * Get adresse value
     * @return \StructType\AdressedataType|null
     */
    public function getAdresse()
    {
        return $this->adresse;
    }
    /**
     * Set adresse value
     * @param \StructType\AdressedataType $adresse
     * @return \StructType\PersonLookupResponseType
     */
    public function setAdresse(\StructType\AdressedataType $adresse = null)
    {
        $this->adresse = $adresse;
        return $this;
    }
    /**
     * Get relationer value
     * @return \StructType\RelationerType|null
     */
    public function getRelationer()
    {
        return $this->relationer;
    }
    /**
     * Set relationer value
     * @param \StructType\RelationerType $relationer
     * @return \StructType\PersonLookupResponseType
     */
    public function setRelationer(\StructType\RelationerType $relationer = null)
    {
        $this->relationer = $relationer;
        return $this;
    }
    /**
     * Get notater value
     * @return \StructType\NotatType[]|null
     */
    public function getNotater()
    {
        return $this->notater;
    }
    /**
     * This method is responsible for validating the values passed to the setNotater method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotater method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotaterForArrayConstraintsFromSetNotater(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personLookupResponseTypeNotaterItem) {
            // validation for constraint: itemType
            if (!$personLookupResponseTypeNotaterItem instanceof \StructType\NotatType) {
                $invalidValues[] = is_object($personLookupResponseTypeNotaterItem) ? get_class($personLookupResponseTypeNotaterItem) : sprintf('%s(%s)', gettype($personLookupResponseTypeNotaterItem), var_export($personLookupResponseTypeNotaterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The notater property can only contain items of type \StructType\NotatType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set notater value
     * @throws \InvalidArgumentException
     * @param \StructType\NotatType[] $notater
     * @return \StructType\PersonLookupResponseType
     */
    public function setNotater(array $notater = array())
    {
        // validation for constraint: array
        if ('' !== ($notaterArrayErrorMessage = self::validateNotaterForArrayConstraintsFromSetNotater($notater))) {
            throw new \InvalidArgumentException($notaterArrayErrorMessage, __LINE__);
        }
        $this->notater = $notater;
        return $this;
    }
    /**
     * Add item to notater value
     * @throws \InvalidArgumentException
     * @param \StructType\NotatType $item
     * @return \StructType\PersonLookupResponseType
     */
    public function addToNotater(\StructType\NotatType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NotatType) {
            throw new \InvalidArgumentException(sprintf('The notater property can only contain items of type \StructType\NotatType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->notater[] = $item;
        return $this;
    }
}
