<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for navnType StructType
 * @subpackage Structs
 */
class NavnType extends AbstractStructBase
{
    /**
     * The personadresseringsnavn
     * @var string
     */
    public $personadresseringsnavn;
    /**
     * The fornavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fornavn;
    /**
     * The mellemnavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mellemnavn;
    /**
     * The efternavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $efternavn;
    /**
     * The fornavnMarkering
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fornavnMarkering;
    /**
     * The mellemnavnMarkering
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mellemnavnMarkering;
    /**
     * The efternavnMarkering
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $efternavnMarkering;
    /**
     * The navnestartdato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UsikkerhedDatoTidType
     */
    public $navnestartdato;
    /**
     * Constructor method for navnType
     * @uses NavnType::setPersonadresseringsnavn()
     * @uses NavnType::setFornavn()
     * @uses NavnType::setMellemnavn()
     * @uses NavnType::setEfternavn()
     * @uses NavnType::setFornavnMarkering()
     * @uses NavnType::setMellemnavnMarkering()
     * @uses NavnType::setEfternavnMarkering()
     * @uses NavnType::setNavnestartdato()
     * @param string $personadresseringsnavn
     * @param string $fornavn
     * @param string $mellemnavn
     * @param string $efternavn
     * @param string $fornavnMarkering
     * @param string $mellemnavnMarkering
     * @param string $efternavnMarkering
     * @param \StructType\UsikkerhedDatoTidType $navnestartdato
     */
    public function __construct($personadresseringsnavn = null, $fornavn = null, $mellemnavn = null, $efternavn = null, $fornavnMarkering = null, $mellemnavnMarkering = null, $efternavnMarkering = null, \StructType\UsikkerhedDatoTidType $navnestartdato = null)
    {
        $this
            ->setPersonadresseringsnavn($personadresseringsnavn)
            ->setFornavn($fornavn)
            ->setMellemnavn($mellemnavn)
            ->setEfternavn($efternavn)
            ->setFornavnMarkering($fornavnMarkering)
            ->setMellemnavnMarkering($mellemnavnMarkering)
            ->setEfternavnMarkering($efternavnMarkering)
            ->setNavnestartdato($navnestartdato);
    }
    /**
     * Get personadresseringsnavn value
     * @return string|null
     */
    public function getPersonadresseringsnavn()
    {
        return $this->personadresseringsnavn;
    }
    /**
     * Set personadresseringsnavn value
     * @param string $personadresseringsnavn
     * @return \StructType\NavnType
     */
    public function setPersonadresseringsnavn($personadresseringsnavn = null)
    {
        // validation for constraint: string
        if (!is_null($personadresseringsnavn) && !is_string($personadresseringsnavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personadresseringsnavn, true), gettype($personadresseringsnavn)), __LINE__);
        }
        $this->personadresseringsnavn = $personadresseringsnavn;
        return $this;
    }
    /**
     * Get fornavn value
     * @return string|null
     */
    public function getFornavn()
    {
        return $this->fornavn;
    }
    /**
     * Set fornavn value
     * @param string $fornavn
     * @return \StructType\NavnType
     */
    public function setFornavn($fornavn = null)
    {
        // validation for constraint: string
        if (!is_null($fornavn) && !is_string($fornavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fornavn, true), gettype($fornavn)), __LINE__);
        }
        $this->fornavn = $fornavn;
        return $this;
    }
    /**
     * Get mellemnavn value
     * @return string|null
     */
    public function getMellemnavn()
    {
        return $this->mellemnavn;
    }
    /**
     * Set mellemnavn value
     * @param string $mellemnavn
     * @return \StructType\NavnType
     */
    public function setMellemnavn($mellemnavn = null)
    {
        // validation for constraint: string
        if (!is_null($mellemnavn) && !is_string($mellemnavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mellemnavn, true), gettype($mellemnavn)), __LINE__);
        }
        $this->mellemnavn = $mellemnavn;
        return $this;
    }
    /**
     * Get efternavn value
     * @return string|null
     */
    public function getEfternavn()
    {
        return $this->efternavn;
    }
    /**
     * Set efternavn value
     * @param string $efternavn
     * @return \StructType\NavnType
     */
    public function setEfternavn($efternavn = null)
    {
        // validation for constraint: string
        if (!is_null($efternavn) && !is_string($efternavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($efternavn, true), gettype($efternavn)), __LINE__);
        }
        $this->efternavn = $efternavn;
        return $this;
    }
    /**
     * Get fornavnMarkering value
     * @return string|null
     */
    public function getFornavnMarkering()
    {
        return $this->fornavnMarkering;
    }
    /**
     * Set fornavnMarkering value
     * @param string $fornavnMarkering
     * @return \StructType\NavnType
     */
    public function setFornavnMarkering($fornavnMarkering = null)
    {
        // validation for constraint: string
        if (!is_null($fornavnMarkering) && !is_string($fornavnMarkering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fornavnMarkering, true), gettype($fornavnMarkering)), __LINE__);
        }
        $this->fornavnMarkering = $fornavnMarkering;
        return $this;
    }
    /**
     * Get mellemnavnMarkering value
     * @return string|null
     */
    public function getMellemnavnMarkering()
    {
        return $this->mellemnavnMarkering;
    }
    /**
     * Set mellemnavnMarkering value
     * @param string $mellemnavnMarkering
     * @return \StructType\NavnType
     */
    public function setMellemnavnMarkering($mellemnavnMarkering = null)
    {
        // validation for constraint: string
        if (!is_null($mellemnavnMarkering) && !is_string($mellemnavnMarkering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mellemnavnMarkering, true), gettype($mellemnavnMarkering)), __LINE__);
        }
        $this->mellemnavnMarkering = $mellemnavnMarkering;
        return $this;
    }
    /**
     * Get efternavnMarkering value
     * @return string|null
     */
    public function getEfternavnMarkering()
    {
        return $this->efternavnMarkering;
    }
    /**
     * Set efternavnMarkering value
     * @param string $efternavnMarkering
     * @return \StructType\NavnType
     */
    public function setEfternavnMarkering($efternavnMarkering = null)
    {
        // validation for constraint: string
        if (!is_null($efternavnMarkering) && !is_string($efternavnMarkering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($efternavnMarkering, true), gettype($efternavnMarkering)), __LINE__);
        }
        $this->efternavnMarkering = $efternavnMarkering;
        return $this;
    }
    /**
     * Get navnestartdato value
     * @return \StructType\UsikkerhedDatoTidType|null
     */
    public function getNavnestartdato()
    {
        return $this->navnestartdato;
    }
    /**
     * Set navnestartdato value
     * @param \StructType\UsikkerhedDatoTidType $navnestartdato
     * @return \StructType\NavnType
     */
    public function setNavnestartdato(\StructType\UsikkerhedDatoTidType $navnestartdato = null)
    {
        $this->navnestartdato = $navnestartdato;
        return $this;
    }
}
