<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adressedataType StructType
 * @subpackage Structs
 */
class AdressedataType extends AbstractStructBase
{
    /**
     * The aktuelAdresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdresseType
     */
    public $aktuelAdresse;
    /**
     * The udrejseoplysninger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UdrejseoplysningerType
     */
    public $udrejseoplysninger;
    /**
     * The kontaktAdresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KontaktAdresseType
     */
    public $kontaktAdresse;
    /**
     * The adresseHistorik
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AdresseHistorikType[]
     */
    public $adresseHistorik;
    /**
     * Constructor method for adressedataType
     * @uses AdressedataType::setAktuelAdresse()
     * @uses AdressedataType::setUdrejseoplysninger()
     * @uses AdressedataType::setKontaktAdresse()
     * @uses AdressedataType::setAdresseHistorik()
     * @param \StructType\AdresseType $aktuelAdresse
     * @param \StructType\UdrejseoplysningerType $udrejseoplysninger
     * @param \StructType\KontaktAdresseType $kontaktAdresse
     * @param \StructType\AdresseHistorikType[] $adresseHistorik
     */
    public function __construct(\StructType\AdresseType $aktuelAdresse = null, \StructType\UdrejseoplysningerType $udrejseoplysninger = null, \StructType\KontaktAdresseType $kontaktAdresse = null, array $adresseHistorik = array())
    {
        $this
            ->setAktuelAdresse($aktuelAdresse)
            ->setUdrejseoplysninger($udrejseoplysninger)
            ->setKontaktAdresse($kontaktAdresse)
            ->setAdresseHistorik($adresseHistorik);
    }
    /**
     * Get aktuelAdresse value
     * @return \StructType\AdresseType|null
     */
    public function getAktuelAdresse()
    {
        return $this->aktuelAdresse;
    }
    /**
     * Set aktuelAdresse value
     * @param \StructType\AdresseType $aktuelAdresse
     * @return \StructType\AdressedataType
     */
    public function setAktuelAdresse(\StructType\AdresseType $aktuelAdresse = null)
    {
        $this->aktuelAdresse = $aktuelAdresse;
        return $this;
    }
    /**
     * Get udrejseoplysninger value
     * @return \StructType\UdrejseoplysningerType|null
     */
    public function getUdrejseoplysninger()
    {
        return $this->udrejseoplysninger;
    }
    /**
     * Set udrejseoplysninger value
     * @param \StructType\UdrejseoplysningerType $udrejseoplysninger
     * @return \StructType\AdressedataType
     */
    public function setUdrejseoplysninger(\StructType\UdrejseoplysningerType $udrejseoplysninger = null)
    {
        $this->udrejseoplysninger = $udrejseoplysninger;
        return $this;
    }
    /**
     * Get kontaktAdresse value
     * @return \StructType\KontaktAdresseType|null
     */
    public function getKontaktAdresse()
    {
        return $this->kontaktAdresse;
    }
    /**
     * Set kontaktAdresse value
     * @param \StructType\KontaktAdresseType $kontaktAdresse
     * @return \StructType\AdressedataType
     */
    public function setKontaktAdresse(\StructType\KontaktAdresseType $kontaktAdresse = null)
    {
        $this->kontaktAdresse = $kontaktAdresse;
        return $this;
    }
    /**
     * Get adresseHistorik value
     * @return \StructType\AdresseHistorikType[]|null
     */
    public function getAdresseHistorik()
    {
        return $this->adresseHistorik;
    }
    /**
     * This method is responsible for validating the values passed to the setAdresseHistorik method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdresseHistorik method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdresseHistorikForArrayConstraintsFromSetAdresseHistorik(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adressedataTypeAdresseHistorikItem) {
            // validation for constraint: itemType
            if (!$adressedataTypeAdresseHistorikItem instanceof \StructType\AdresseHistorikType) {
                $invalidValues[] = is_object($adressedataTypeAdresseHistorikItem) ? get_class($adressedataTypeAdresseHistorikItem) : sprintf('%s(%s)', gettype($adressedataTypeAdresseHistorikItem), var_export($adressedataTypeAdresseHistorikItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The adresseHistorik property can only contain items of type \StructType\AdresseHistorikType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set adresseHistorik value
     * @throws \InvalidArgumentException
     * @param \StructType\AdresseHistorikType[] $adresseHistorik
     * @return \StructType\AdressedataType
     */
    public function setAdresseHistorik(array $adresseHistorik = array())
    {
        // validation for constraint: array
        if ('' !== ($adresseHistorikArrayErrorMessage = self::validateAdresseHistorikForArrayConstraintsFromSetAdresseHistorik($adresseHistorik))) {
            throw new \InvalidArgumentException($adresseHistorikArrayErrorMessage, __LINE__);
        }
        $this->adresseHistorik = $adresseHistorik;
        return $this;
    }
    /**
     * Add item to adresseHistorik value
     * @throws \InvalidArgumentException
     * @param \StructType\AdresseHistorikType $item
     * @return \StructType\AdressedataType
     */
    public function addToAdresseHistorik(\StructType\AdresseHistorikType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdresseHistorikType) {
            throw new \InvalidArgumentException(sprintf('The adresseHistorik property can only contain items of type \StructType\AdresseHistorikType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->adresseHistorik[] = $item;
        return $this;
    }
}
