<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvocationContextType StructType
 * @subpackage Structs
 */
class InvocationContextType extends AbstractStructBase
{
    /**
     * The ServiceAgreementUUID
     * Meta information extracted from the WSDL
     * - base: tns:UUIDtype
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * - ref: tns:ServiceAgreementUUID
     * @var string
     */
    public $ServiceAgreementUUID;
    /**
     * The UserSystemUUID
     * Meta information extracted from the WSDL
     * - base: tns:UUIDtype
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * - ref: tns:UserSystemUUID
     * @var string
     */
    public $UserSystemUUID;
    /**
     * The UserUUID
     * Meta information extracted from the WSDL
     * - base: tns:UUIDtype
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * - ref: tns:UserUUID
     * @var string
     */
    public $UserUUID;
    /**
     * The ServiceUUID
     * Meta information extracted from the WSDL
     * - base: tns:UUIDtype
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * - ref: tns:ServiceUUID
     * @var string
     */
    public $ServiceUUID;
    /**
     * The OnBehalfOfUser
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:OnBehalfOfUser
     * @var string
     */
    public $OnBehalfOfUser;
    /**
     * The CallersServiceCallIdentifier
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:CallersServiceCallIdentifier
     * @var string
     */
    public $CallersServiceCallIdentifier;
    /**
     * The AccountingInfo
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:AccountingInfo
     * @var string
     */
    public $AccountingInfo;
    /**
     * Constructor method for InvocationContextType
     * @uses InvocationContextType::setServiceAgreementUUID()
     * @uses InvocationContextType::setUserSystemUUID()
     * @uses InvocationContextType::setUserUUID()
     * @uses InvocationContextType::setServiceUUID()
     * @uses InvocationContextType::setOnBehalfOfUser()
     * @uses InvocationContextType::setCallersServiceCallIdentifier()
     * @uses InvocationContextType::setAccountingInfo()
     * @param string $serviceAgreementUUID
     * @param string $userSystemUUID
     * @param string $userUUID
     * @param string $serviceUUID
     * @param string $onBehalfOfUser
     * @param string $callersServiceCallIdentifier
     * @param string $accountingInfo
     */
    public function __construct($serviceAgreementUUID = null, $userSystemUUID = null, $userUUID = null, $serviceUUID = null, $onBehalfOfUser = null, $callersServiceCallIdentifier = null, $accountingInfo = null)
    {
        $this
            ->setServiceAgreementUUID($serviceAgreementUUID)
            ->setUserSystemUUID($userSystemUUID)
            ->setUserUUID($userUUID)
            ->setServiceUUID($serviceUUID)
            ->setOnBehalfOfUser($onBehalfOfUser)
            ->setCallersServiceCallIdentifier($callersServiceCallIdentifier)
            ->setAccountingInfo($accountingInfo);
    }
    /**
     * Get ServiceAgreementUUID value
     * @return string
     */
    public function getServiceAgreementUUID()
    {
        return $this->ServiceAgreementUUID;
    }
    /**
     * Set ServiceAgreementUUID value
     * @param string $serviceAgreementUUID
     * @return \StructType\InvocationContextType
     */
    public function setServiceAgreementUUID($serviceAgreementUUID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAgreementUUID) && !is_string($serviceAgreementUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceAgreementUUID, true), gettype($serviceAgreementUUID)), __LINE__);
        }
        // validation for constraint: pattern([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})
        if (!is_null($serviceAgreementUUID) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $serviceAgreementUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', var_export($serviceAgreementUUID, true)), __LINE__);
        }
        $this->ServiceAgreementUUID = $serviceAgreementUUID;
        return $this;
    }
    /**
     * Get UserSystemUUID value
     * @return string
     */
    public function getUserSystemUUID()
    {
        return $this->UserSystemUUID;
    }
    /**
     * Set UserSystemUUID value
     * @param string $userSystemUUID
     * @return \StructType\InvocationContextType
     */
    public function setUserSystemUUID($userSystemUUID = null)
    {
        // validation for constraint: string
        if (!is_null($userSystemUUID) && !is_string($userSystemUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userSystemUUID, true), gettype($userSystemUUID)), __LINE__);
        }
        // validation for constraint: pattern([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})
        if (!is_null($userSystemUUID) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $userSystemUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', var_export($userSystemUUID, true)), __LINE__);
        }
        $this->UserSystemUUID = $userSystemUUID;
        return $this;
    }
    /**
     * Get UserUUID value
     * @return string
     */
    public function getUserUUID()
    {
        return $this->UserUUID;
    }
    /**
     * Set UserUUID value
     * @param string $userUUID
     * @return \StructType\InvocationContextType
     */
    public function setUserUUID($userUUID = null)
    {
        // validation for constraint: string
        if (!is_null($userUUID) && !is_string($userUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userUUID, true), gettype($userUUID)), __LINE__);
        }
        // validation for constraint: pattern([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})
        if (!is_null($userUUID) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $userUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', var_export($userUUID, true)), __LINE__);
        }
        $this->UserUUID = $userUUID;
        return $this;
    }
    /**
     * Get ServiceUUID value
     * @return string
     */
    public function getServiceUUID()
    {
        return $this->ServiceUUID;
    }
    /**
     * Set ServiceUUID value
     * @param string $serviceUUID
     * @return \StructType\InvocationContextType
     */
    public function setServiceUUID($serviceUUID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceUUID) && !is_string($serviceUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceUUID, true), gettype($serviceUUID)), __LINE__);
        }
        // validation for constraint: pattern([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})
        if (!is_null($serviceUUID) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $serviceUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', var_export($serviceUUID, true)), __LINE__);
        }
        $this->ServiceUUID = $serviceUUID;
        return $this;
    }
    /**
     * Get OnBehalfOfUser value
     * @return string|null
     */
    public function getOnBehalfOfUser()
    {
        return $this->OnBehalfOfUser;
    }
    /**
     * Set OnBehalfOfUser value
     * @param string $onBehalfOfUser
     * @return \StructType\InvocationContextType
     */
    public function setOnBehalfOfUser($onBehalfOfUser = null)
    {
        // validation for constraint: string
        if (!is_null($onBehalfOfUser) && !is_string($onBehalfOfUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onBehalfOfUser, true), gettype($onBehalfOfUser)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($onBehalfOfUser) && mb_strlen($onBehalfOfUser) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($onBehalfOfUser)), __LINE__);
        }
        $this->OnBehalfOfUser = $onBehalfOfUser;
        return $this;
    }
    /**
     * Get CallersServiceCallIdentifier value
     * @return string|null
     */
    public function getCallersServiceCallIdentifier()
    {
        return $this->CallersServiceCallIdentifier;
    }
    /**
     * Set CallersServiceCallIdentifier value
     * @param string $callersServiceCallIdentifier
     * @return \StructType\InvocationContextType
     */
    public function setCallersServiceCallIdentifier($callersServiceCallIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($callersServiceCallIdentifier) && !is_string($callersServiceCallIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callersServiceCallIdentifier, true), gettype($callersServiceCallIdentifier)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($callersServiceCallIdentifier) && mb_strlen($callersServiceCallIdentifier) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($callersServiceCallIdentifier)), __LINE__);
        }
        $this->CallersServiceCallIdentifier = $callersServiceCallIdentifier;
        return $this;
    }
    /**
     * Get AccountingInfo value
     * @return string|null
     */
    public function getAccountingInfo()
    {
        return $this->AccountingInfo;
    }
    /**
     * Set AccountingInfo value
     * @param string $accountingInfo
     * @return \StructType\InvocationContextType
     */
    public function setAccountingInfo($accountingInfo = null)
    {
        // validation for constraint: string
        if (!is_null($accountingInfo) && !is_string($accountingInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountingInfo, true), gettype($accountingInfo)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($accountingInfo) && mb_strlen($accountingInfo) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($accountingInfo)), __LINE__);
        }
        $this->AccountingInfo = $accountingInfo;
        return $this;
    }
}
