<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adresseHistorikType StructType
 * @subpackage Structs
 */
class AdresseHistorikType extends AbstractStructBase
{
    /**
     * The kommuneCvr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kommuneCvr;
    /**
     * The kommunekode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $kommunekode;
    /**
     * The vejkode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $vejkode;
    /**
     * The husnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $husnummer;
    /**
     * The etage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $etage;
    /**
     * The sidedoer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sidedoer;
    /**
     * The bygningsnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bygningsnummer;
    /**
     * The conavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $conavn;
    /**
     * The lokalitet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lokalitet;
    /**
     * The bynavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bynavn;
    /**
     * The postnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postnummer;
    /**
     * The postdistrikt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postdistrikt;
    /**
     * The vejnavn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vejnavn;
    /**
     * The retFortrydMarkering
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retFortrydMarkering;
    /**
     * The tilflytningsdato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UsikkerhedDatoTidType
     */
    public $tilflytningsdato;
    /**
     * The fraflytningsdato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UsikkerhedDatoTidType
     */
    public $fraflytningsdato;
    /**
     * Constructor method for adresseHistorikType
     * @uses AdresseHistorikType::setKommuneCvr()
     * @uses AdresseHistorikType::setKommunekode()
     * @uses AdresseHistorikType::setVejkode()
     * @uses AdresseHistorikType::setHusnummer()
     * @uses AdresseHistorikType::setEtage()
     * @uses AdresseHistorikType::setSidedoer()
     * @uses AdresseHistorikType::setBygningsnummer()
     * @uses AdresseHistorikType::setConavn()
     * @uses AdresseHistorikType::setLokalitet()
     * @uses AdresseHistorikType::setBynavn()
     * @uses AdresseHistorikType::setPostnummer()
     * @uses AdresseHistorikType::setPostdistrikt()
     * @uses AdresseHistorikType::setVejnavn()
     * @uses AdresseHistorikType::setRetFortrydMarkering()
     * @uses AdresseHistorikType::setTilflytningsdato()
     * @uses AdresseHistorikType::setFraflytningsdato()
     * @param string $kommuneCvr
     * @param int $kommunekode
     * @param int $vejkode
     * @param string $husnummer
     * @param string $etage
     * @param string $sidedoer
     * @param string $bygningsnummer
     * @param string $conavn
     * @param string $lokalitet
     * @param string $bynavn
     * @param string $postnummer
     * @param string $postdistrikt
     * @param string $vejnavn
     * @param string $retFortrydMarkering
     * @param \StructType\UsikkerhedDatoTidType $tilflytningsdato
     * @param \StructType\UsikkerhedDatoTidType $fraflytningsdato
     */
    public function __construct($kommuneCvr = null, $kommunekode = null, $vejkode = null, $husnummer = null, $etage = null, $sidedoer = null, $bygningsnummer = null, $conavn = null, $lokalitet = null, $bynavn = null, $postnummer = null, $postdistrikt = null, $vejnavn = null, $retFortrydMarkering = null, \StructType\UsikkerhedDatoTidType $tilflytningsdato = null, \StructType\UsikkerhedDatoTidType $fraflytningsdato = null)
    {
        $this
            ->setKommuneCvr($kommuneCvr)
            ->setKommunekode($kommunekode)
            ->setVejkode($vejkode)
            ->setHusnummer($husnummer)
            ->setEtage($etage)
            ->setSidedoer($sidedoer)
            ->setBygningsnummer($bygningsnummer)
            ->setConavn($conavn)
            ->setLokalitet($lokalitet)
            ->setBynavn($bynavn)
            ->setPostnummer($postnummer)
            ->setPostdistrikt($postdistrikt)
            ->setVejnavn($vejnavn)
            ->setRetFortrydMarkering($retFortrydMarkering)
            ->setTilflytningsdato($tilflytningsdato)
            ->setFraflytningsdato($fraflytningsdato);
    }
    /**
     * Get kommuneCvr value
     * @return string|null
     */
    public function getKommuneCvr()
    {
        return $this->kommuneCvr;
    }
    /**
     * Set kommuneCvr value
     * @param string $kommuneCvr
     * @return \StructType\AdresseHistorikType
     */
    public function setKommuneCvr($kommuneCvr = null)
    {
        // validation for constraint: string
        if (!is_null($kommuneCvr) && !is_string($kommuneCvr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kommuneCvr, true), gettype($kommuneCvr)), __LINE__);
        }
        $this->kommuneCvr = $kommuneCvr;
        return $this;
    }
    /**
     * Get kommunekode value
     * @return int|null
     */
    public function getKommunekode()
    {
        return $this->kommunekode;
    }
    /**
     * Set kommunekode value
     * @param int $kommunekode
     * @return \StructType\AdresseHistorikType
     */
    public function setKommunekode($kommunekode = null)
    {
        // validation for constraint: int
        if (!is_null($kommunekode) && !(is_int($kommunekode) || ctype_digit($kommunekode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kommunekode, true), gettype($kommunekode)), __LINE__);
        }
        $this->kommunekode = $kommunekode;
        return $this;
    }
    /**
     * Get vejkode value
     * @return int|null
     */
    public function getVejkode()
    {
        return $this->vejkode;
    }
    /**
     * Set vejkode value
     * @param int $vejkode
     * @return \StructType\AdresseHistorikType
     */
    public function setVejkode($vejkode = null)
    {
        // validation for constraint: int
        if (!is_null($vejkode) && !(is_int($vejkode) || ctype_digit($vejkode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vejkode, true), gettype($vejkode)), __LINE__);
        }
        $this->vejkode = $vejkode;
        return $this;
    }
    /**
     * Get husnummer value
     * @return string|null
     */
    public function getHusnummer()
    {
        return $this->husnummer;
    }
    /**
     * Set husnummer value
     * @param string $husnummer
     * @return \StructType\AdresseHistorikType
     */
    public function setHusnummer($husnummer = null)
    {
        // validation for constraint: string
        if (!is_null($husnummer) && !is_string($husnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($husnummer, true), gettype($husnummer)), __LINE__);
        }
        $this->husnummer = $husnummer;
        return $this;
    }
    /**
     * Get etage value
     * @return string|null
     */
    public function getEtage()
    {
        return $this->etage;
    }
    /**
     * Set etage value
     * @param string $etage
     * @return \StructType\AdresseHistorikType
     */
    public function setEtage($etage = null)
    {
        // validation for constraint: string
        if (!is_null($etage) && !is_string($etage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($etage, true), gettype($etage)), __LINE__);
        }
        $this->etage = $etage;
        return $this;
    }
    /**
     * Get sidedoer value
     * @return string|null
     */
    public function getSidedoer()
    {
        return $this->sidedoer;
    }
    /**
     * Set sidedoer value
     * @param string $sidedoer
     * @return \StructType\AdresseHistorikType
     */
    public function setSidedoer($sidedoer = null)
    {
        // validation for constraint: string
        if (!is_null($sidedoer) && !is_string($sidedoer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sidedoer, true), gettype($sidedoer)), __LINE__);
        }
        $this->sidedoer = $sidedoer;
        return $this;
    }
    /**
     * Get bygningsnummer value
     * @return string|null
     */
    public function getBygningsnummer()
    {
        return $this->bygningsnummer;
    }
    /**
     * Set bygningsnummer value
     * @param string $bygningsnummer
     * @return \StructType\AdresseHistorikType
     */
    public function setBygningsnummer($bygningsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($bygningsnummer) && !is_string($bygningsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bygningsnummer, true), gettype($bygningsnummer)), __LINE__);
        }
        $this->bygningsnummer = $bygningsnummer;
        return $this;
    }
    /**
     * Get conavn value
     * @return string|null
     */
    public function getConavn()
    {
        return $this->conavn;
    }
    /**
     * Set conavn value
     * @param string $conavn
     * @return \StructType\AdresseHistorikType
     */
    public function setConavn($conavn = null)
    {
        // validation for constraint: string
        if (!is_null($conavn) && !is_string($conavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conavn, true), gettype($conavn)), __LINE__);
        }
        $this->conavn = $conavn;
        return $this;
    }
    /**
     * Get lokalitet value
     * @return string|null
     */
    public function getLokalitet()
    {
        return $this->lokalitet;
    }
    /**
     * Set lokalitet value
     * @param string $lokalitet
     * @return \StructType\AdresseHistorikType
     */
    public function setLokalitet($lokalitet = null)
    {
        // validation for constraint: string
        if (!is_null($lokalitet) && !is_string($lokalitet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lokalitet, true), gettype($lokalitet)), __LINE__);
        }
        $this->lokalitet = $lokalitet;
        return $this;
    }
    /**
     * Get bynavn value
     * @return string|null
     */
    public function getBynavn()
    {
        return $this->bynavn;
    }
    /**
     * Set bynavn value
     * @param string $bynavn
     * @return \StructType\AdresseHistorikType
     */
    public function setBynavn($bynavn = null)
    {
        // validation for constraint: string
        if (!is_null($bynavn) && !is_string($bynavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bynavn, true), gettype($bynavn)), __LINE__);
        }
        $this->bynavn = $bynavn;
        return $this;
    }
    /**
     * Get postnummer value
     * @return string|null
     */
    public function getPostnummer()
    {
        return $this->postnummer;
    }
    /**
     * Set postnummer value
     * @param string $postnummer
     * @return \StructType\AdresseHistorikType
     */
    public function setPostnummer($postnummer = null)
    {
        // validation for constraint: string
        if (!is_null($postnummer) && !is_string($postnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postnummer, true), gettype($postnummer)), __LINE__);
        }
        $this->postnummer = $postnummer;
        return $this;
    }
    /**
     * Get postdistrikt value
     * @return string|null
     */
    public function getPostdistrikt()
    {
        return $this->postdistrikt;
    }
    /**
     * Set postdistrikt value
     * @param string $postdistrikt
     * @return \StructType\AdresseHistorikType
     */
    public function setPostdistrikt($postdistrikt = null)
    {
        // validation for constraint: string
        if (!is_null($postdistrikt) && !is_string($postdistrikt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postdistrikt, true), gettype($postdistrikt)), __LINE__);
        }
        $this->postdistrikt = $postdistrikt;
        return $this;
    }
    /**
     * Get vejnavn value
     * @return string|null
     */
    public function getVejnavn()
    {
        return $this->vejnavn;
    }
    /**
     * Set vejnavn value
     * @param string $vejnavn
     * @return \StructType\AdresseHistorikType
     */
    public function setVejnavn($vejnavn = null)
    {
        // validation for constraint: string
        if (!is_null($vejnavn) && !is_string($vejnavn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vejnavn, true), gettype($vejnavn)), __LINE__);
        }
        $this->vejnavn = $vejnavn;
        return $this;
    }
    /**
     * Get retFortrydMarkering value
     * @return string|null
     */
    public function getRetFortrydMarkering()
    {
        return $this->retFortrydMarkering;
    }
    /**
     * Set retFortrydMarkering value
     * @param string $retFortrydMarkering
     * @return \StructType\AdresseHistorikType
     */
    public function setRetFortrydMarkering($retFortrydMarkering = null)
    {
        // validation for constraint: string
        if (!is_null($retFortrydMarkering) && !is_string($retFortrydMarkering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retFortrydMarkering, true), gettype($retFortrydMarkering)), __LINE__);
        }
        $this->retFortrydMarkering = $retFortrydMarkering;
        return $this;
    }
    /**
     * Get tilflytningsdato value
     * @return \StructType\UsikkerhedDatoTidType|null
     */
    public function getTilflytningsdato()
    {
        return $this->tilflytningsdato;
    }
    /**
     * Set tilflytningsdato value
     * @param \StructType\UsikkerhedDatoTidType $tilflytningsdato
     * @return \StructType\AdresseHistorikType
     */
    public function setTilflytningsdato(\StructType\UsikkerhedDatoTidType $tilflytningsdato = null)
    {
        $this->tilflytningsdato = $tilflytningsdato;
        return $this;
    }
    /**
     * Get fraflytningsdato value
     * @return \StructType\UsikkerhedDatoTidType|null
     */
    public function getFraflytningsdato()
    {
        return $this->fraflytningsdato;
    }
    /**
     * Set fraflytningsdato value
     * @param \StructType\UsikkerhedDatoTidType $fraflytningsdato
     * @return \StructType\AdresseHistorikType
     */
    public function setFraflytningsdato(\StructType\UsikkerhedDatoTidType $fraflytningsdato = null)
    {
        $this->fraflytningsdato = $fraflytningsdato;
        return $this;
    }
}
