<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Person ServiceType
 * @subpackage Services
 */
class Person extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PersonLookup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PersonLookupRequestType $request
     * @return \StructType\PersonLookupResponseType|bool
     */
    public function PersonLookup(\StructType\PersonLookupRequestType $request)
    {
        try {
            $this->setResult($this->getSoapClient()->PersonLookup($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PersonLookupResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
