<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.masternaut.co.uk/JobTransfer/V3/jobservice.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.masternaut.co.uk/JobTransfer/V3/jobservice.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for Ping operation/method
 */
if ($ping->Ping(new \StructType\Ping()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getJobCollection operation/method
 */
if ($get->getJobCollection(new \StructType\GetJobCollection()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getJobCollectionV2 operation/method
 */
if ($get->getJobCollectionV2(new \StructType\GetJobCollectionV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCurrentDrivers operation/method
 */
if ($get->getCurrentDrivers(new \StructType\GetCurrentDrivers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNearestVehicle operation/method
 */
if ($get->getNearestVehicle(new \StructType\GetNearestVehicle()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNearestVehicleV2 operation/method
 */
if ($get->getNearestVehicleV2(new \StructType\GetNearestVehicleV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVehicleUpdate operation/method
 */
if ($get->getVehicleUpdate(new \StructType\GetVehicleUpdate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVehicleUpdateV2 operation/method
 */
if ($get->getVehicleUpdateV2(new \StructType\GetVehicleUpdateV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHistory operation/method
 */
if ($get->GetHistory(new \StructType\GetHistory()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHistoryV2 operation/method
 */
if ($get->GetHistoryV2(new \StructType\GetHistoryV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVehiclesAtContact operation/method
 */
if ($get->GetVehiclesAtContact(new \StructType\GetVehiclesAtContact()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVersion operation/method
 */
if ($get->GetVersion(new \StructType\GetVersion()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVehicleCalculatedCurrentOdometerReadings operation/method
 */
if ($get->GetVehicleCalculatedCurrentOdometerReadings(new \StructType\GetVehicleCalculatedCurrentOdometerReadings()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeliveryStatusChange operation/method
 */
if ($get->GetDeliveryStatusChange(new \StructType\GetDeliveryStatusChange()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDistanceTravelled operation/method
 */
if ($get->GetDistanceTravelled(new \StructType\GetDistanceTravelled()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for addLocation operation/method
 */
if ($add->addLocation(new \StructType\AddLocation()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addLocationV2 operation/method
 */
if ($add->addLocationV2(new \StructType\AddLocationV2()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddVehicleActualOdometerReadings operation/method
 */
if ($add->AddVehicleActualOdometerReadings(new \StructType\AddVehicleActualOdometerReadings()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteLocation operation/method
 */
if ($delete->deleteLocation(new \StructType\DeleteLocation()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteRoute operation/method
 */
if ($delete->DeleteRoute(new \StructType\DeleteRoute()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createRoute operation/method
 */
if ($create->createRoute(new \StructType\CreateRoute()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createJob operation/method
 */
if ($create->createJob(new \StructType\CreateJob()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAllocatedRoute operation/method
 */
if ($create->CreateAllocatedRoute(new \StructType\CreateAllocatedRoute()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAllocatedRouteV2 operation/method
 */
if ($create->CreateAllocatedRouteV2(new \StructType\CreateAllocatedRouteV2()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAllocatedRouteV2ForVehicle operation/method
 */
if ($create->CreateAllocatedRouteV2ForVehicle(new \StructType\CreateAllocatedRouteV2ForVehicle()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateLateArrivalAlertForRouteStop operation/method
 */
if ($create->CreateLateArrivalAlertForRouteStop(new \StructType\CreateLateArrivalAlertForRouteStop()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateEtaAlertForRouteStop operation/method
 */
if ($create->CreateEtaAlertForRouteStop(new \StructType\CreateEtaAlertForRouteStop()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateTemperatureAlertForVehicle operation/method
 */
if ($create->CreateTemperatureAlertForVehicle(new \StructType\CreateTemperatureAlertForVehicle()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetVehicleNextServiceInformation operation/method
 */
if ($set->SetVehicleNextServiceInformation(new \StructType\SetVehicleNextServiceInformation()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetGroupForVehicles operation/method
 */
if ($set->SetGroupForVehicles(new \StructType\SetGroupForVehicles()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateDeliveryStart operation/method
 */
if ($update->UpdateDeliveryStart(new \StructType\UpdateDeliveryStart()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDeliveryEnd operation/method
 */
if ($update->UpdateDeliveryEnd(new \StructType\UpdateDeliveryEnd()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDeliveryCompletionDetails operation/method
 */
if ($update->UpdateDeliveryCompletionDetails(new \StructType\UpdateDeliveryCompletionDetails()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDeliveryCompletionDetailsV2 operation/method
 */
if ($update->UpdateDeliveryCompletionDetailsV2(new \StructType\UpdateDeliveryCompletionDetailsV2()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDeliveryLineItemQuantities operation/method
 */
if ($update->UpdateDeliveryLineItemQuantities(new \StructType\UpdateDeliveryLineItemQuantities()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Load ServiceType
 */
$load = new \ServiceType\Load($options);
/**
 * Sample call for LoadVehicleChecks operation/method
 */
if ($load->LoadVehicleChecks(new \StructType\LoadVehicleChecks()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Samples for De ServiceType
 */
$de = new \ServiceType\De($options);
/**
 * Sample call for DeActivateTemperatureAlertForVehicle operation/method
 */
if ($de->DeActivateTemperatureAlertForVehicle(new \StructType\DeActivateTemperatureAlertForVehicle()) !== false) {
    print_r($de->getResult());
} else {
    print_r($de->getLastError());
}
