<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebServiceStopAlert StructType
 * @subpackage Structs
 */
abstract class WebServiceStopAlert extends WebServiceAlert
{
    /**
     * The RouteReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RouteReference;
    /**
     * The StopReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StopReference;
    /**
     * Constructor method for WebServiceStopAlert
     * @uses WebServiceStopAlert::setRouteReference()
     * @uses WebServiceStopAlert::setStopReference()
     * @param string $routeReference
     * @param string $stopReference
     */
    public function __construct($routeReference = null, $stopReference = null)
    {
        $this
            ->setRouteReference($routeReference)
            ->setStopReference($stopReference);
    }
    /**
     * Get RouteReference value
     * @return string|null
     */
    public function getRouteReference()
    {
        return $this->RouteReference;
    }
    /**
     * Set RouteReference value
     * @param string $routeReference
     * @return \StructType\WebServiceStopAlert
     */
    public function setRouteReference($routeReference = null)
    {
        // validation for constraint: string
        if (!is_null($routeReference) && !is_string($routeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeReference)), __LINE__);
        }
        $this->RouteReference = $routeReference;
        return $this;
    }
    /**
     * Get StopReference value
     * @return string|null
     */
    public function getStopReference()
    {
        return $this->StopReference;
    }
    /**
     * Set StopReference value
     * @param string $stopReference
     * @return \StructType\WebServiceStopAlert
     */
    public function setStopReference($stopReference = null)
    {
        // validation for constraint: string
        if (!is_null($stopReference) && !is_string($stopReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stopReference)), __LINE__);
        }
        $this->StopReference = $stopReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebServiceStopAlert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
