<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleOdometerReading StructType
 * @subpackage Structs
 */
class VehicleOdometerReading extends OpenElementElement
{
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Distance;
    /**
     * The TimeStamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TimeStamp;
    /**
     * The HasValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasValue;
    /**
     * The VehicleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleName;
    /**
     * Constructor method for VehicleOdometerReading
     * @uses VehicleOdometerReading::setDistance()
     * @uses VehicleOdometerReading::setTimeStamp()
     * @uses VehicleOdometerReading::setHasValue()
     * @uses VehicleOdometerReading::setVehicleName()
     * @param int $distance
     * @param string $timeStamp
     * @param bool $hasValue
     * @param string $vehicleName
     */
    public function __construct($distance = null, $timeStamp = null, $hasValue = null, $vehicleName = null)
    {
        $this
            ->setDistance($distance)
            ->setTimeStamp($timeStamp)
            ->setHasValue($hasValue)
            ->setVehicleName($vehicleName);
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\VehicleOdometerReading
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\VehicleOdometerReading
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get HasValue value
     * @return bool
     */
    public function getHasValue()
    {
        return $this->HasValue;
    }
    /**
     * Set HasValue value
     * @param bool $hasValue
     * @return \StructType\VehicleOdometerReading
     */
    public function setHasValue($hasValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasValue) && !is_bool($hasValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasValue)), __LINE__);
        }
        $this->HasValue = $hasValue;
        return $this;
    }
    /**
     * Get VehicleName value
     * @return string|null
     */
    public function getVehicleName()
    {
        return $this->VehicleName;
    }
    /**
     * Set VehicleName value
     * @param string $vehicleName
     * @return \StructType\VehicleOdometerReading
     */
    public function setVehicleName($vehicleName = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleName) && !is_string($vehicleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleName)), __LINE__);
        }
        $this->VehicleName = $vehicleName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleOdometerReading
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
