<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationV2 StructType
 * @subpackage Structs
 */
class LocationV2 extends OpenElementElement
{
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The sweepradius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $sweepradius;
    /**
     * The expiryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $expiryDate;
    /**
     * The flaggedLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $flaggedLocation;
    /**
     * The group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $group;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The town
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $town;
    /**
     * The borough
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $borough;
    /**
     * The road
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $road;
    /**
     * The roadnumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roadnumber;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The information
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $information;
    /**
     * The department
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The area
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $area;
    /**
     * The custom1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $custom1;
    /**
     * The custom2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $custom2;
    /**
     * The custom3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $custom3;
    /**
     * The custom4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $custom4;
    /**
     * The contactCompany
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contactCompany;
    /**
     * The contactName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contactName;
    /**
     * The contactPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contactPhone;
    /**
     * The contactMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contactMail;
    /**
     * Constructor method for LocationV2
     * @uses LocationV2::setLongitude()
     * @uses LocationV2::setLatitude()
     * @uses LocationV2::setSweepradius()
     * @uses LocationV2::setExpiryDate()
     * @uses LocationV2::setFlaggedLocation()
     * @uses LocationV2::setGroup()
     * @uses LocationV2::setReference()
     * @uses LocationV2::setName()
     * @uses LocationV2::setCountry()
     * @uses LocationV2::setTown()
     * @uses LocationV2::setBorough()
     * @uses LocationV2::setRoad()
     * @uses LocationV2::setRoadnumber()
     * @uses LocationV2::setPostcode()
     * @uses LocationV2::setInformation()
     * @uses LocationV2::setDepartment()
     * @uses LocationV2::setArea()
     * @uses LocationV2::setCustom1()
     * @uses LocationV2::setCustom2()
     * @uses LocationV2::setCustom3()
     * @uses LocationV2::setCustom4()
     * @uses LocationV2::setContactCompany()
     * @uses LocationV2::setContactName()
     * @uses LocationV2::setContactPhone()
     * @uses LocationV2::setContactMail()
     * @param float $longitude
     * @param float $latitude
     * @param int $sweepradius
     * @param string $expiryDate
     * @param bool $flaggedLocation
     * @param string $group
     * @param string $reference
     * @param string $name
     * @param string $country
     * @param string $town
     * @param string $borough
     * @param string $road
     * @param string $roadnumber
     * @param string $postcode
     * @param string $information
     * @param string $department
     * @param string $area
     * @param string $custom1
     * @param string $custom2
     * @param string $custom3
     * @param string $custom4
     * @param string $contactCompany
     * @param string $contactName
     * @param string $contactPhone
     * @param string $contactMail
     */
    public function __construct($longitude = null, $latitude = null, $sweepradius = null, $expiryDate = null, $flaggedLocation = null, $group = null, $reference = null, $name = null, $country = null, $town = null, $borough = null, $road = null, $roadnumber = null, $postcode = null, $information = null, $department = null, $area = null, $custom1 = null, $custom2 = null, $custom3 = null, $custom4 = null, $contactCompany = null, $contactName = null, $contactPhone = null, $contactMail = null)
    {
        $this
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setSweepradius($sweepradius)
            ->setExpiryDate($expiryDate)
            ->setFlaggedLocation($flaggedLocation)
            ->setGroup($group)
            ->setReference($reference)
            ->setName($name)
            ->setCountry($country)
            ->setTown($town)
            ->setBorough($borough)
            ->setRoad($road)
            ->setRoadnumber($roadnumber)
            ->setPostcode($postcode)
            ->setInformation($information)
            ->setDepartment($department)
            ->setArea($area)
            ->setCustom1($custom1)
            ->setCustom2($custom2)
            ->setCustom3($custom3)
            ->setCustom4($custom4)
            ->setContactCompany($contactCompany)
            ->setContactName($contactName)
            ->setContactPhone($contactPhone)
            ->setContactMail($contactMail);
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\LocationV2
     */
    public function setLongitude($longitude = null)
    {
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\LocationV2
     */
    public function setLatitude($latitude = null)
    {
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get sweepradius value
     * @return int
     */
    public function getSweepradius()
    {
        return $this->sweepradius;
    }
    /**
     * Set sweepradius value
     * @param int $sweepradius
     * @return \StructType\LocationV2
     */
    public function setSweepradius($sweepradius = null)
    {
        // validation for constraint: int
        if (!is_null($sweepradius) && !is_numeric($sweepradius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sweepradius)), __LINE__);
        }
        $this->sweepradius = $sweepradius;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \StructType\LocationV2
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get flaggedLocation value
     * @return bool
     */
    public function getFlaggedLocation()
    {
        return $this->flaggedLocation;
    }
    /**
     * Set flaggedLocation value
     * @param bool $flaggedLocation
     * @return \StructType\LocationV2
     */
    public function setFlaggedLocation($flaggedLocation = null)
    {
        // validation for constraint: boolean
        if (!is_null($flaggedLocation) && !is_bool($flaggedLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($flaggedLocation)), __LINE__);
        }
        $this->flaggedLocation = $flaggedLocation;
        return $this;
    }
    /**
     * Get group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @param string $group
     * @return \StructType\LocationV2
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($group)), __LINE__);
        }
        $this->group = $group;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\LocationV2
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LocationV2
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\LocationV2
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->town;
    }
    /**
     * Set town value
     * @param string $town
     * @return \StructType\LocationV2
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($town)), __LINE__);
        }
        $this->town = $town;
        return $this;
    }
    /**
     * Get borough value
     * @return string|null
     */
    public function getBorough()
    {
        return $this->borough;
    }
    /**
     * Set borough value
     * @param string $borough
     * @return \StructType\LocationV2
     */
    public function setBorough($borough = null)
    {
        // validation for constraint: string
        if (!is_null($borough) && !is_string($borough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($borough)), __LINE__);
        }
        $this->borough = $borough;
        return $this;
    }
    /**
     * Get road value
     * @return string|null
     */
    public function getRoad()
    {
        return $this->road;
    }
    /**
     * Set road value
     * @param string $road
     * @return \StructType\LocationV2
     */
    public function setRoad($road = null)
    {
        // validation for constraint: string
        if (!is_null($road) && !is_string($road)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road)), __LINE__);
        }
        $this->road = $road;
        return $this;
    }
    /**
     * Get roadnumber value
     * @return string|null
     */
    public function getRoadnumber()
    {
        return $this->roadnumber;
    }
    /**
     * Set roadnumber value
     * @param string $roadnumber
     * @return \StructType\LocationV2
     */
    public function setRoadnumber($roadnumber = null)
    {
        // validation for constraint: string
        if (!is_null($roadnumber) && !is_string($roadnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roadnumber)), __LINE__);
        }
        $this->roadnumber = $roadnumber;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\LocationV2
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->information;
    }
    /**
     * Set information value
     * @param string $information
     * @return \StructType\LocationV2
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($information)), __LINE__);
        }
        $this->information = $information;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \StructType\LocationV2
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get area value
     * @return string|null
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param string $area
     * @return \StructType\LocationV2
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area)), __LINE__);
        }
        $this->area = $area;
        return $this;
    }
    /**
     * Get custom1 value
     * @return string|null
     */
    public function getCustom1()
    {
        return $this->custom1;
    }
    /**
     * Set custom1 value
     * @param string $custom1
     * @return \StructType\LocationV2
     */
    public function setCustom1($custom1 = null)
    {
        // validation for constraint: string
        if (!is_null($custom1) && !is_string($custom1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom1)), __LINE__);
        }
        $this->custom1 = $custom1;
        return $this;
    }
    /**
     * Get custom2 value
     * @return string|null
     */
    public function getCustom2()
    {
        return $this->custom2;
    }
    /**
     * Set custom2 value
     * @param string $custom2
     * @return \StructType\LocationV2
     */
    public function setCustom2($custom2 = null)
    {
        // validation for constraint: string
        if (!is_null($custom2) && !is_string($custom2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom2)), __LINE__);
        }
        $this->custom2 = $custom2;
        return $this;
    }
    /**
     * Get custom3 value
     * @return string|null
     */
    public function getCustom3()
    {
        return $this->custom3;
    }
    /**
     * Set custom3 value
     * @param string $custom3
     * @return \StructType\LocationV2
     */
    public function setCustom3($custom3 = null)
    {
        // validation for constraint: string
        if (!is_null($custom3) && !is_string($custom3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom3)), __LINE__);
        }
        $this->custom3 = $custom3;
        return $this;
    }
    /**
     * Get custom4 value
     * @return string|null
     */
    public function getCustom4()
    {
        return $this->custom4;
    }
    /**
     * Set custom4 value
     * @param string $custom4
     * @return \StructType\LocationV2
     */
    public function setCustom4($custom4 = null)
    {
        // validation for constraint: string
        if (!is_null($custom4) && !is_string($custom4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom4)), __LINE__);
        }
        $this->custom4 = $custom4;
        return $this;
    }
    /**
     * Get contactCompany value
     * @return string|null
     */
    public function getContactCompany()
    {
        return $this->contactCompany;
    }
    /**
     * Set contactCompany value
     * @param string $contactCompany
     * @return \StructType\LocationV2
     */
    public function setContactCompany($contactCompany = null)
    {
        // validation for constraint: string
        if (!is_null($contactCompany) && !is_string($contactCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactCompany)), __LINE__);
        }
        $this->contactCompany = $contactCompany;
        return $this;
    }
    /**
     * Get contactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->contactName;
    }
    /**
     * Set contactName value
     * @param string $contactName
     * @return \StructType\LocationV2
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->contactName = $contactName;
        return $this;
    }
    /**
     * Get contactPhone value
     * @return string|null
     */
    public function getContactPhone()
    {
        return $this->contactPhone;
    }
    /**
     * Set contactPhone value
     * @param string $contactPhone
     * @return \StructType\LocationV2
     */
    public function setContactPhone($contactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($contactPhone) && !is_string($contactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactPhone)), __LINE__);
        }
        $this->contactPhone = $contactPhone;
        return $this;
    }
    /**
     * Get contactMail value
     * @return string|null
     */
    public function getContactMail()
    {
        return $this->contactMail;
    }
    /**
     * Set contactMail value
     * @param string $contactMail
     * @return \StructType\LocationV2
     */
    public function setContactMail($contactMail = null)
    {
        // validation for constraint: string
        if (!is_null($contactMail) && !is_string($contactMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactMail)), __LINE__);
        }
        $this->contactMail = $contactMail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocationV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
