<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineItem StructType
 * @subpackage Structs
 */
class LineItem extends AbstractStructBase
{
    /**
     * The LineReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineReference;
    /**
     * The SkuItemNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SkuItemNumber;
    /**
     * The PlannedQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlannedQuantity;
    /**
     * The ActualQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActualQuantity;
    /**
     * The AmendmentReason1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AmendmentReason1;
    /**
     * The AmendmentReason2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AmendmentReason2;
    /**
     * Constructor method for LineItem
     * @uses LineItem::setLineReference()
     * @uses LineItem::setSkuItemNumber()
     * @uses LineItem::setPlannedQuantity()
     * @uses LineItem::setActualQuantity()
     * @uses LineItem::setAmendmentReason1()
     * @uses LineItem::setAmendmentReason2()
     * @param string $lineReference
     * @param string $skuItemNumber
     * @param string $plannedQuantity
     * @param string $actualQuantity
     * @param string $amendmentReason1
     * @param string $amendmentReason2
     */
    public function __construct($lineReference = null, $skuItemNumber = null, $plannedQuantity = null, $actualQuantity = null, $amendmentReason1 = null, $amendmentReason2 = null)
    {
        $this
            ->setLineReference($lineReference)
            ->setSkuItemNumber($skuItemNumber)
            ->setPlannedQuantity($plannedQuantity)
            ->setActualQuantity($actualQuantity)
            ->setAmendmentReason1($amendmentReason1)
            ->setAmendmentReason2($amendmentReason2);
    }
    /**
     * Get LineReference value
     * @return string|null
     */
    public function getLineReference()
    {
        return $this->LineReference;
    }
    /**
     * Set LineReference value
     * @param string $lineReference
     * @return \StructType\LineItem
     */
    public function setLineReference($lineReference = null)
    {
        // validation for constraint: string
        if (!is_null($lineReference) && !is_string($lineReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineReference)), __LINE__);
        }
        $this->LineReference = $lineReference;
        return $this;
    }
    /**
     * Get SkuItemNumber value
     * @return string|null
     */
    public function getSkuItemNumber()
    {
        return $this->SkuItemNumber;
    }
    /**
     * Set SkuItemNumber value
     * @param string $skuItemNumber
     * @return \StructType\LineItem
     */
    public function setSkuItemNumber($skuItemNumber = null)
    {
        // validation for constraint: string
        if (!is_null($skuItemNumber) && !is_string($skuItemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skuItemNumber)), __LINE__);
        }
        $this->SkuItemNumber = $skuItemNumber;
        return $this;
    }
    /**
     * Get PlannedQuantity value
     * @return string|null
     */
    public function getPlannedQuantity()
    {
        return $this->PlannedQuantity;
    }
    /**
     * Set PlannedQuantity value
     * @param string $plannedQuantity
     * @return \StructType\LineItem
     */
    public function setPlannedQuantity($plannedQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($plannedQuantity) && !is_string($plannedQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plannedQuantity)), __LINE__);
        }
        $this->PlannedQuantity = $plannedQuantity;
        return $this;
    }
    /**
     * Get ActualQuantity value
     * @return string|null
     */
    public function getActualQuantity()
    {
        return $this->ActualQuantity;
    }
    /**
     * Set ActualQuantity value
     * @param string $actualQuantity
     * @return \StructType\LineItem
     */
    public function setActualQuantity($actualQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($actualQuantity) && !is_string($actualQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualQuantity)), __LINE__);
        }
        $this->ActualQuantity = $actualQuantity;
        return $this;
    }
    /**
     * Get AmendmentReason1 value
     * @return string|null
     */
    public function getAmendmentReason1()
    {
        return $this->AmendmentReason1;
    }
    /**
     * Set AmendmentReason1 value
     * @param string $amendmentReason1
     * @return \StructType\LineItem
     */
    public function setAmendmentReason1($amendmentReason1 = null)
    {
        // validation for constraint: string
        if (!is_null($amendmentReason1) && !is_string($amendmentReason1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amendmentReason1)), __LINE__);
        }
        $this->AmendmentReason1 = $amendmentReason1;
        return $this;
    }
    /**
     * Get AmendmentReason2 value
     * @return string|null
     */
    public function getAmendmentReason2()
    {
        return $this->AmendmentReason2;
    }
    /**
     * Set AmendmentReason2 value
     * @param string $amendmentReason2
     * @return \StructType\LineItem
     */
    public function setAmendmentReason2($amendmentReason2 = null)
    {
        // validation for constraint: string
        if (!is_null($amendmentReason2) && !is_string($amendmentReason2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amendmentReason2)), __LINE__);
        }
        $this->AmendmentReason2 = $amendmentReason2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LineItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
