<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobV2 StructType
 * @subpackage Structs
 */
class JobV2 extends Job
{
    /**
     * The signatureData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $signatureData;
    /**
     * The items
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLineItem
     */
    public $items;
    /**
     * Constructor method for JobV2
     * @uses JobV2::setSignatureData()
     * @uses JobV2::setItems()
     * @param string $signatureData
     * @param \ArrayType\ArrayOfLineItem $items
     */
    public function __construct($signatureData = null, \ArrayType\ArrayOfLineItem $items = null)
    {
        $this
            ->setSignatureData($signatureData)
            ->setItems($items);
    }
    /**
     * Get signatureData value
     * @return string|null
     */
    public function getSignatureData()
    {
        return $this->signatureData;
    }
    /**
     * Set signatureData value
     * @param string $signatureData
     * @return \StructType\JobV2
     */
    public function setSignatureData($signatureData = null)
    {
        // validation for constraint: string
        if (!is_null($signatureData) && !is_string($signatureData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatureData)), __LINE__);
        }
        $this->signatureData = $signatureData;
        return $this;
    }
    /**
     * Get items value
     * @return \ArrayType\ArrayOfLineItem|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \ArrayType\ArrayOfLineItem $items
     * @return \StructType\JobV2
     */
    public function setItems(\ArrayType\ArrayOfLineItem $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JobV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
