<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHistory StructType
 * @subpackage Structs
 */
class GetHistory extends AbstractStructBase
{
    /**
     * The vehicleCollectionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $vehicleCollectionType;
    /**
     * The start
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $start;
    /**
     * The end
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $end;
    /**
     * The reverseGeocode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $reverseGeocode;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The vehicleOrGroupNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $vehicleOrGroupNames;
    /**
     * The eventsToReturn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEventType
     */
    public $eventsToReturn;
    /**
     * Constructor method for GetHistory
     * @uses GetHistory::setVehicleCollectionType()
     * @uses GetHistory::setStart()
     * @uses GetHistory::setEnd()
     * @uses GetHistory::setReverseGeocode()
     * @uses GetHistory::setLogin()
     * @uses GetHistory::setPassword()
     * @uses GetHistory::setVehicleOrGroupNames()
     * @uses GetHistory::setEventsToReturn()
     * @param string $vehicleCollectionType
     * @param string $start
     * @param string $end
     * @param bool $reverseGeocode
     * @param string $login
     * @param string $password
     * @param \ArrayType\ArrayOfString $vehicleOrGroupNames
     * @param \ArrayType\ArrayOfEventType $eventsToReturn
     */
    public function __construct($vehicleCollectionType = null, $start = null, $end = null, $reverseGeocode = null, $login = null, $password = null, \ArrayType\ArrayOfString $vehicleOrGroupNames = null, \ArrayType\ArrayOfEventType $eventsToReturn = null)
    {
        $this
            ->setVehicleCollectionType($vehicleCollectionType)
            ->setStart($start)
            ->setEnd($end)
            ->setReverseGeocode($reverseGeocode)
            ->setLogin($login)
            ->setPassword($password)
            ->setVehicleOrGroupNames($vehicleOrGroupNames)
            ->setEventsToReturn($eventsToReturn);
    }
    /**
     * Get vehicleCollectionType value
     * @return string
     */
    public function getVehicleCollectionType()
    {
        return $this->vehicleCollectionType;
    }
    /**
     * Set vehicleCollectionType value
     * @uses \EnumType\VehicleCollectionType::valueIsValid()
     * @uses \EnumType\VehicleCollectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleCollectionType
     * @return \StructType\GetHistory
     */
    public function setVehicleCollectionType($vehicleCollectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleCollectionType::valueIsValid($vehicleCollectionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleCollectionType, implode(', ', \EnumType\VehicleCollectionType::getValidValues())), __LINE__);
        }
        $this->vehicleCollectionType = $vehicleCollectionType;
        return $this;
    }
    /**
     * Get start value
     * @return string
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param string $start
     * @return \StructType\GetHistory
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return string
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param string $end
     * @return \StructType\GetHistory
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->end = $end;
        return $this;
    }
    /**
     * Get reverseGeocode value
     * @return bool
     */
    public function getReverseGeocode()
    {
        return $this->reverseGeocode;
    }
    /**
     * Set reverseGeocode value
     * @param bool $reverseGeocode
     * @return \StructType\GetHistory
     */
    public function setReverseGeocode($reverseGeocode = null)
    {
        // validation for constraint: boolean
        if (!is_null($reverseGeocode) && !is_bool($reverseGeocode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reverseGeocode)), __LINE__);
        }
        $this->reverseGeocode = $reverseGeocode;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\GetHistory
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetHistory
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get vehicleOrGroupNames value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getVehicleOrGroupNames()
    {
        return $this->vehicleOrGroupNames;
    }
    /**
     * Set vehicleOrGroupNames value
     * @param \ArrayType\ArrayOfString $vehicleOrGroupNames
     * @return \StructType\GetHistory
     */
    public function setVehicleOrGroupNames(\ArrayType\ArrayOfString $vehicleOrGroupNames = null)
    {
        $this->vehicleOrGroupNames = $vehicleOrGroupNames;
        return $this;
    }
    /**
     * Get eventsToReturn value
     * @return \ArrayType\ArrayOfEventType|null
     */
    public function getEventsToReturn()
    {
        return $this->eventsToReturn;
    }
    /**
     * Set eventsToReturn value
     * @param \ArrayType\ArrayOfEventType $eventsToReturn
     * @return \StructType\GetHistory
     */
    public function setEventsToReturn(\ArrayType\ArrayOfEventType $eventsToReturn = null)
    {
        $this->eventsToReturn = $eventsToReturn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
