<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateAlertsResult StructType
 * @subpackage Structs
 */
class CreateAlertsResult extends AbstractStructBase
{
    /**
     * The Succeeded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Succeeded;
    /**
     * The FailureReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FailureReason;
    /**
     * Constructor method for CreateAlertsResult
     * @uses CreateAlertsResult::setSucceeded()
     * @uses CreateAlertsResult::setFailureReason()
     * @param bool $succeeded
     * @param string $failureReason
     */
    public function __construct($succeeded = null, $failureReason = null)
    {
        $this
            ->setSucceeded($succeeded)
            ->setFailureReason($failureReason);
    }
    /**
     * Get Succeeded value
     * @return bool
     */
    public function getSucceeded()
    {
        return $this->Succeeded;
    }
    /**
     * Set Succeeded value
     * @param bool $succeeded
     * @return \StructType\CreateAlertsResult
     */
    public function setSucceeded($succeeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($succeeded) && !is_bool($succeeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($succeeded)), __LINE__);
        }
        $this->Succeeded = $succeeded;
        return $this;
    }
    /**
     * Get FailureReason value
     * @return string|null
     */
    public function getFailureReason()
    {
        return $this->FailureReason;
    }
    /**
     * Set FailureReason value
     * @param string $failureReason
     * @return \StructType\CreateAlertsResult
     */
    public function setFailureReason($failureReason = null)
    {
        // validation for constraint: string
        if (!is_null($failureReason) && !is_string($failureReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureReason)), __LINE__);
        }
        $this->FailureReason = $failureReason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateAlertsResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
