<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for collection StructType
 * @subpackage Structs
 */
class Collection extends AbstractStructBase
{
    /**
     * The collectionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $collectionStatus;
    /**
     * The collectionref
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $collectionref;
    /**
     * The driverReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driverReference;
    /**
     * Constructor method for collection
     * @uses Collection::setCollectionStatus()
     * @uses Collection::setCollectionref()
     * @uses Collection::setDriverReference()
     * @param int $collectionStatus
     * @param string $collectionref
     * @param string $driverReference
     */
    public function __construct($collectionStatus = null, $collectionref = null, $driverReference = null)
    {
        $this
            ->setCollectionStatus($collectionStatus)
            ->setCollectionref($collectionref)
            ->setDriverReference($driverReference);
    }
    /**
     * Get collectionStatus value
     * @return int
     */
    public function getCollectionStatus()
    {
        return $this->collectionStatus;
    }
    /**
     * Set collectionStatus value
     * @param int $collectionStatus
     * @return \StructType\Collection
     */
    public function setCollectionStatus($collectionStatus = null)
    {
        // validation for constraint: int
        if (!is_null($collectionStatus) && !is_numeric($collectionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($collectionStatus)), __LINE__);
        }
        $this->collectionStatus = $collectionStatus;
        return $this;
    }
    /**
     * Get collectionref value
     * @return string|null
     */
    public function getCollectionref()
    {
        return $this->collectionref;
    }
    /**
     * Set collectionref value
     * @param string $collectionref
     * @return \StructType\Collection
     */
    public function setCollectionref($collectionref = null)
    {
        // validation for constraint: string
        if (!is_null($collectionref) && !is_string($collectionref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectionref)), __LINE__);
        }
        $this->collectionref = $collectionref;
        return $this;
    }
    /**
     * Get driverReference value
     * @return string|null
     */
    public function getDriverReference()
    {
        return $this->driverReference;
    }
    /**
     * Set driverReference value
     * @param string $driverReference
     * @return \StructType\Collection
     */
    public function setDriverReference($driverReference = null)
    {
        // validation for constraint: string
        if (!is_null($driverReference) && !is_string($driverReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverReference)), __LINE__);
        }
        $this->driverReference = $driverReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Collection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
