<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllocatedRouteV2 StructType
 * @subpackage Structs
 */
class AllocatedRouteV2 extends AllocatedRoute
{
    /**
     * The DriverType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DriverType;
    /**
     * Constructor method for AllocatedRouteV2
     * @uses AllocatedRouteV2::setDriverType()
     * @param string $driverType
     */
    public function __construct($driverType = null)
    {
        $this
            ->setDriverType($driverType);
    }
    /**
     * Get DriverType value
     * @return string
     */
    public function getDriverType()
    {
        return $this->DriverType;
    }
    /**
     * Set DriverType value
     * @uses \EnumType\AllocatedDriverType::valueIsValid()
     * @uses \EnumType\AllocatedDriverType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $driverType
     * @return \StructType\AllocatedRouteV2
     */
    public function setDriverType($driverType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AllocatedDriverType::valueIsValid($driverType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $driverType, implode(', ', \EnumType\AllocatedDriverType::getValidValues())), __LINE__);
        }
        $this->DriverType = $driverType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllocatedRouteV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
