<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllocatedRoute StructType
 * @subpackage Structs
 */
class AllocatedRoute extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The AllocatedDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllocatedDriver;
    /**
     * The Deliveries
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDelivery
     */
    public $Deliveries;
    /**
     * Constructor method for AllocatedRoute
     * @uses AllocatedRoute::setStartDate()
     * @uses AllocatedRoute::setAllocatedDriver()
     * @uses AllocatedRoute::setDeliveries()
     * @param string $startDate
     * @param string $allocatedDriver
     * @param \ArrayType\ArrayOfDelivery $deliveries
     */
    public function __construct($startDate = null, $allocatedDriver = null, \ArrayType\ArrayOfDelivery $deliveries = null)
    {
        $this
            ->setStartDate($startDate)
            ->setAllocatedDriver($allocatedDriver)
            ->setDeliveries($deliveries);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\AllocatedRoute
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get AllocatedDriver value
     * @return string|null
     */
    public function getAllocatedDriver()
    {
        return $this->AllocatedDriver;
    }
    /**
     * Set AllocatedDriver value
     * @param string $allocatedDriver
     * @return \StructType\AllocatedRoute
     */
    public function setAllocatedDriver($allocatedDriver = null)
    {
        // validation for constraint: string
        if (!is_null($allocatedDriver) && !is_string($allocatedDriver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allocatedDriver)), __LINE__);
        }
        $this->AllocatedDriver = $allocatedDriver;
        return $this;
    }
    /**
     * Get Deliveries value
     * @return \ArrayType\ArrayOfDelivery|null
     */
    public function getDeliveries()
    {
        return $this->Deliveries;
    }
    /**
     * Set Deliveries value
     * @param \ArrayType\ArrayOfDelivery $deliveries
     * @return \StructType\AllocatedRoute
     */
    public function setDeliveries(\ArrayType\ArrayOfDelivery $deliveries = null)
    {
        $this->Deliveries = $deliveries;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllocatedRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
