<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createRoute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateRoute $parameters
     * @return \StructType\CreateRouteResponse|bool
     */
    public function createRoute(\StructType\CreateRoute $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createRoute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateJob $parameters
     * @return \StructType\CreateJobResponse|bool
     */
    public function createJob(\StructType\CreateJob $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAllocatedRoute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAllocatedRoute $parameters
     * @return \StructType\CreateAllocatedRouteResponse|bool
     */
    public function CreateAllocatedRoute(\StructType\CreateAllocatedRoute $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateAllocatedRoute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAllocatedRouteV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAllocatedRouteV2 $parameters
     * @return \StructType\CreateAllocatedRouteV2Response|bool
     */
    public function CreateAllocatedRouteV2(\StructType\CreateAllocatedRouteV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateAllocatedRouteV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAllocatedRouteV2ForVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAllocatedRouteV2ForVehicle $parameters
     * @return \StructType\CreateAllocatedRouteV2ForVehicleResponse|bool
     */
    public function CreateAllocatedRouteV2ForVehicle(\StructType\CreateAllocatedRouteV2ForVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateAllocatedRouteV2ForVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateLateArrivalAlertForRouteStop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateLateArrivalAlertForRouteStop $parameters
     * @return \StructType\CreateLateArrivalAlertForRouteStopResponse|bool
     */
    public function CreateLateArrivalAlertForRouteStop(\StructType\CreateLateArrivalAlertForRouteStop $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateLateArrivalAlertForRouteStop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateEtaAlertForRouteStop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateEtaAlertForRouteStop $parameters
     * @return \StructType\CreateEtaAlertForRouteStopResponse|bool
     */
    public function CreateEtaAlertForRouteStop(\StructType\CreateEtaAlertForRouteStop $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateEtaAlertForRouteStop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateTemperatureAlertForVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTemperatureAlertForVehicle $parameters
     * @return \StructType\CreateTemperatureAlertForVehicleResponse|bool
     */
    public function CreateTemperatureAlertForVehicle(\StructType\CreateTemperatureAlertForVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateTemperatureAlertForVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateAllocatedRouteResponse|\StructType\CreateAllocatedRouteV2ForVehicleResponse|\StructType\CreateAllocatedRouteV2Response|\StructType\CreateEtaAlertForRouteStopResponse|\StructType\CreateJobResponse|\StructType\CreateLateArrivalAlertForRouteStopResponse|\StructType\CreateRouteResponse|\StructType\CreateTemperatureAlertForVehicleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
