<?php

namespace EnumType;

/**
 * This class stands for VehicleCollectionType EnumType
 * @subpackage Enumerations
 */
class VehicleCollectionType
{
    /**
     * Constant for value 'Vehicles'
     * @return string 'Vehicles'
     */
    const VALUE_VEHICLES = 'Vehicles';
    /**
     * Constant for value 'Groups'
     * @return string 'Groups'
     */
    const VALUE_GROUPS = 'Groups';
    /**
     * Constant for value 'Null'
     * @return string 'Null'
     */
    const VALUE_NULL = 'Null';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VEHICLES
     * @uses self::VALUE_GROUPS
     * @uses self::VALUE_NULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VEHICLES,
            self::VALUE_GROUPS,
            self::VALUE_NULL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
