<?php

namespace EnumType;

/**
 * This class stands for statusOptions EnumType
 * @subpackage Enumerations
 */
class StatusOptions
{
    /**
     * Constant for value 'NotStarted'
     * @return string 'NotStarted'
     */
    const VALUE_NOT_STARTED = 'NotStarted';
    /**
     * Constant for value 'Started'
     * @return string 'Started'
     */
    const VALUE_STARTED = 'Started';
    /**
     * Constant for value 'Finished'
     * @return string 'Finished'
     */
    const VALUE_FINISHED = 'Finished';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_STARTED
     * @uses self::VALUE_STARTED
     * @uses self::VALUE_FINISHED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_STARTED,
            self::VALUE_STARTED,
            self::VALUE_FINISHED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
