<?php

namespace EnumType;

/**
 * This class stands for statusOption_v2 EnumType
 * @subpackage Enumerations
 */
class StatusOption_v2
{
    /**
     * Constant for value 'Driving'
     * @return string 'Driving'
     */
    const VALUE_DRIVING = 'Driving';
    /**
     * Constant for value 'Idling'
     * @return string 'Idling'
     */
    const VALUE_IDLING = 'Idling';
    /**
     * Constant for value 'Stopped'
     * @return string 'Stopped'
     */
    const VALUE_STOPPED = 'Stopped';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DRIVING
     * @uses self::VALUE_IDLING
     * @uses self::VALUE_STOPPED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DRIVING,
            self::VALUE_IDLING,
            self::VALUE_STOPPED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
