<?php

namespace EnumType;

/**
 * This class stands for SearchData EnumType
 * @subpackage Enumerations
 */
class SearchData
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'ArrivedAt'
     * @return string 'ArrivedAt'
     */
    const VALUE_ARRIVED_AT = 'ArrivedAt';
    /**
     * Constant for value 'DepartedFrom'
     * @return string 'DepartedFrom'
     */
    const VALUE_DEPARTED_FROM = 'DepartedFrom';
    /**
     * Constant for value 'InProgress'
     * @return string 'InProgress'
     */
    const VALUE_IN_PROGRESS = 'InProgress';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_ARRIVED_AT
     * @uses self::VALUE_DEPARTED_FROM
     * @uses self::VALUE_IN_PROGRESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_ARRIVED_AT,
            self::VALUE_DEPARTED_FROM,
            self::VALUE_IN_PROGRESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
