<?php

namespace EnumType;

/**
 * This class stands for Compartment EnumType
 * @subpackage Enumerations
 */
class Compartment
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'T1'
     * @return string 'T1'
     */
    const VALUE_T_1 = 'T1';
    /**
     * Constant for value 'T2'
     * @return string 'T2'
     */
    const VALUE_T_2 = 'T2';
    /**
     * Constant for value 'T3'
     * @return string 'T3'
     */
    const VALUE_T_3 = 'T3';
    /**
     * Constant for value 'T4'
     * @return string 'T4'
     */
    const VALUE_T_4 = 'T4';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_T_1
     * @uses self::VALUE_T_2
     * @uses self::VALUE_T_3
     * @uses self::VALUE_T_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_T_1,
            self::VALUE_T_2,
            self::VALUE_T_3,
            self::VALUE_T_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
