<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVehicleV2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfVehicleV2 extends AbstractStructArrayBase
{
    /**
     * The VehicleV2
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VehicleV2[]
     */
    public $VehicleV2;
    /**
     * Constructor method for ArrayOfVehicleV2
     * @uses ArrayOfVehicleV2::setVehicleV2()
     * @param \StructType\VehicleV2[] $vehicleV2
     */
    public function __construct(array $vehicleV2 = array())
    {
        $this
            ->setVehicleV2($vehicleV2);
    }
    /**
     * Get VehicleV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VehicleV2[]|null
     */
    public function getVehicleV2()
    {
        return isset($this->VehicleV2) ? $this->VehicleV2 : null;
    }
    /**
     * Set VehicleV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleV2[] $vehicleV2
     * @return \ArrayType\ArrayOfVehicleV2
     */
    public function setVehicleV2(array $vehicleV2 = array())
    {
        foreach ($vehicleV2 as $arrayOfVehicleV2VehicleV2Item) {
            // validation for constraint: itemType
            if (!$arrayOfVehicleV2VehicleV2Item instanceof \StructType\VehicleV2) {
                throw new \InvalidArgumentException(sprintf('The VehicleV2 property can only contain items of \StructType\VehicleV2, "%s" given', is_object($arrayOfVehicleV2VehicleV2Item) ? get_class($arrayOfVehicleV2VehicleV2Item) : gettype($arrayOfVehicleV2VehicleV2Item)), __LINE__);
            }
        }
        if (is_null($vehicleV2) || (is_array($vehicleV2) && empty($vehicleV2))) {
            unset($this->VehicleV2);
        } else {
            $this->VehicleV2 = $vehicleV2;
        }
        return $this;
    }
    /**
     * Add item to VehicleV2 value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleV2 $item
     * @return \ArrayType\ArrayOfVehicleV2
     */
    public function addToVehicleV2(\StructType\VehicleV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleV2) {
            throw new \InvalidArgumentException(sprintf('The VehicleV2 property can only contain items of \StructType\VehicleV2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleV2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VehicleV2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VehicleV2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VehicleV2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VehicleV2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VehicleV2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VehicleV2
     */
    public function getAttributeName()
    {
        return 'VehicleV2';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVehicleV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
