<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventType ArrayType
 * @subpackage Arrays
 */
class ArrayOfEventType extends AbstractStructArrayBase
{
    /**
     * The EventType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EventType[]
     */
    public $EventType;
    /**
     * Constructor method for ArrayOfEventType
     * @uses ArrayOfEventType::setEventType()
     * @param \StructType\EventType[] $eventType
     */
    public function __construct(array $eventType = array())
    {
        $this
            ->setEventType($eventType);
    }
    /**
     * Get EventType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EventType[]|null
     */
    public function getEventType()
    {
        return isset($this->EventType) ? $this->EventType : null;
    }
    /**
     * Set EventType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EventType[] $eventType
     * @return \ArrayType\ArrayOfEventType
     */
    public function setEventType(array $eventType = array())
    {
        foreach ($eventType as $arrayOfEventTypeEventTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventTypeEventTypeItem instanceof \StructType\EventType) {
                throw new \InvalidArgumentException(sprintf('The EventType property can only contain items of \StructType\EventType, "%s" given', is_object($arrayOfEventTypeEventTypeItem) ? get_class($arrayOfEventTypeEventTypeItem) : gettype($arrayOfEventTypeEventTypeItem)), __LINE__);
            }
        }
        if (is_null($eventType) || (is_array($eventType) && empty($eventType))) {
            unset($this->EventType);
        } else {
            $this->EventType = $eventType;
        }
        return $this;
    }
    /**
     * Add item to EventType value
     * @throws \InvalidArgumentException
     * @param \StructType\EventType $item
     * @return \ArrayType\ArrayOfEventType
     */
    public function addToEventType(\StructType\EventType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventType) {
            throw new \InvalidArgumentException(sprintf('The EventType property can only contain items of \StructType\EventType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EventType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EventType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EventType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EventType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EventType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EventType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EventType
     */
    public function getAttributeName()
    {
        return 'EventType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEventType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
