<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebServiceAlert StructType
 * @subpackage Structs
 */
abstract class WebServiceAlert extends OpenElementElement
{
    /**
     * The EmailAddresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $EmailAddresses;
    /**
     * The SmsNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $SmsNumbers;
    /**
     * The PopupUserNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $PopupUserNames;
    /**
     * Constructor method for WebServiceAlert
     * @uses WebServiceAlert::setEmailAddresses()
     * @uses WebServiceAlert::setSmsNumbers()
     * @uses WebServiceAlert::setPopupUserNames()
     * @param \ArrayType\ArrayOfString $emailAddresses
     * @param \ArrayType\ArrayOfString $smsNumbers
     * @param \ArrayType\ArrayOfString $popupUserNames
     */
    public function __construct(\ArrayType\ArrayOfString $emailAddresses = null, \ArrayType\ArrayOfString $smsNumbers = null, \ArrayType\ArrayOfString $popupUserNames = null)
    {
        $this
            ->setEmailAddresses($emailAddresses)
            ->setSmsNumbers($smsNumbers)
            ->setPopupUserNames($popupUserNames);
    }
    /**
     * Get EmailAddresses value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getEmailAddresses()
    {
        return $this->EmailAddresses;
    }
    /**
     * Set EmailAddresses value
     * @param \ArrayType\ArrayOfString $emailAddresses
     * @return \StructType\WebServiceAlert
     */
    public function setEmailAddresses(\ArrayType\ArrayOfString $emailAddresses = null)
    {
        $this->EmailAddresses = $emailAddresses;
        return $this;
    }
    /**
     * Get SmsNumbers value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getSmsNumbers()
    {
        return $this->SmsNumbers;
    }
    /**
     * Set SmsNumbers value
     * @param \ArrayType\ArrayOfString $smsNumbers
     * @return \StructType\WebServiceAlert
     */
    public function setSmsNumbers(\ArrayType\ArrayOfString $smsNumbers = null)
    {
        $this->SmsNumbers = $smsNumbers;
        return $this;
    }
    /**
     * Get PopupUserNames value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getPopupUserNames()
    {
        return $this->PopupUserNames;
    }
    /**
     * Set PopupUserNames value
     * @param \ArrayType\ArrayOfString $popupUserNames
     * @return \StructType\WebServiceAlert
     */
    public function setPopupUserNames(\ArrayType\ArrayOfString $popupUserNames = null)
    {
        $this->PopupUserNames = $popupUserNames;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebServiceAlert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
