<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleV2 StructType
 * @subpackage Structs
 */
class VehicleV2 extends OpenElementElement
{
    /**
     * The distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $distance;
    /**
     * The currentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currentStatus;
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The lastUpdated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastUpdated;
    /**
     * The speedKilometres
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $speedKilometres;
    /**
     * The directionDegrees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $directionDegrees;
    /**
     * The lastCommunicated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastCommunicated;
    /**
     * The registration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $registration;
    /**
     * The road
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $road;
    /**
     * The town
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $town;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The driverName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driverName;
    /**
     * Constructor method for VehicleV2
     * @uses VehicleV2::setDistance()
     * @uses VehicleV2::setCurrentStatus()
     * @uses VehicleV2::setLatitude()
     * @uses VehicleV2::setLongitude()
     * @uses VehicleV2::setLastUpdated()
     * @uses VehicleV2::setSpeedKilometres()
     * @uses VehicleV2::setDirectionDegrees()
     * @uses VehicleV2::setLastCommunicated()
     * @uses VehicleV2::setRegistration()
     * @uses VehicleV2::setRoad()
     * @uses VehicleV2::setTown()
     * @uses VehicleV2::setPostcode()
     * @uses VehicleV2::setCountry()
     * @uses VehicleV2::setDriverName()
     * @param float $distance
     * @param string $currentStatus
     * @param float $latitude
     * @param float $longitude
     * @param string $lastUpdated
     * @param int $speedKilometres
     * @param int $directionDegrees
     * @param string $lastCommunicated
     * @param string $registration
     * @param string $road
     * @param string $town
     * @param string $postcode
     * @param string $country
     * @param string $driverName
     */
    public function __construct($distance = null, $currentStatus = null, $latitude = null, $longitude = null, $lastUpdated = null, $speedKilometres = null, $directionDegrees = null, $lastCommunicated = null, $registration = null, $road = null, $town = null, $postcode = null, $country = null, $driverName = null)
    {
        $this
            ->setDistance($distance)
            ->setCurrentStatus($currentStatus)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setLastUpdated($lastUpdated)
            ->setSpeedKilometres($speedKilometres)
            ->setDirectionDegrees($directionDegrees)
            ->setLastCommunicated($lastCommunicated)
            ->setRegistration($registration)
            ->setRoad($road)
            ->setTown($town)
            ->setPostcode($postcode)
            ->setCountry($country)
            ->setDriverName($driverName);
    }
    /**
     * Get distance value
     * @return float
     */
    public function getDistance()
    {
        return $this->distance;
    }
    /**
     * Set distance value
     * @param float $distance
     * @return \StructType\VehicleV2
     */
    public function setDistance($distance = null)
    {
        $this->distance = $distance;
        return $this;
    }
    /**
     * Get currentStatus value
     * @return string
     */
    public function getCurrentStatus()
    {
        return $this->currentStatus;
    }
    /**
     * Set currentStatus value
     * @uses \EnumType\StatusOption_v2::valueIsValid()
     * @uses \EnumType\StatusOption_v2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currentStatus
     * @return \StructType\VehicleV2
     */
    public function setCurrentStatus($currentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusOption_v2::valueIsValid($currentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currentStatus, implode(', ', \EnumType\StatusOption_v2::getValidValues())), __LINE__);
        }
        $this->currentStatus = $currentStatus;
        return $this;
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\VehicleV2
     */
    public function setLatitude($latitude = null)
    {
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\VehicleV2
     */
    public function setLongitude($longitude = null)
    {
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get lastUpdated value
     * @return string
     */
    public function getLastUpdated()
    {
        return $this->lastUpdated;
    }
    /**
     * Set lastUpdated value
     * @param string $lastUpdated
     * @return \StructType\VehicleV2
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdated)), __LINE__);
        }
        $this->lastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get speedKilometres value
     * @return int
     */
    public function getSpeedKilometres()
    {
        return $this->speedKilometres;
    }
    /**
     * Set speedKilometres value
     * @param int $speedKilometres
     * @return \StructType\VehicleV2
     */
    public function setSpeedKilometres($speedKilometres = null)
    {
        // validation for constraint: int
        if (!is_null($speedKilometres) && !is_numeric($speedKilometres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($speedKilometres)), __LINE__);
        }
        $this->speedKilometres = $speedKilometres;
        return $this;
    }
    /**
     * Get directionDegrees value
     * @return int
     */
    public function getDirectionDegrees()
    {
        return $this->directionDegrees;
    }
    /**
     * Set directionDegrees value
     * @param int $directionDegrees
     * @return \StructType\VehicleV2
     */
    public function setDirectionDegrees($directionDegrees = null)
    {
        // validation for constraint: int
        if (!is_null($directionDegrees) && !is_numeric($directionDegrees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($directionDegrees)), __LINE__);
        }
        $this->directionDegrees = $directionDegrees;
        return $this;
    }
    /**
     * Get lastCommunicated value
     * @return string
     */
    public function getLastCommunicated()
    {
        return $this->lastCommunicated;
    }
    /**
     * Set lastCommunicated value
     * @param string $lastCommunicated
     * @return \StructType\VehicleV2
     */
    public function setLastCommunicated($lastCommunicated = null)
    {
        // validation for constraint: string
        if (!is_null($lastCommunicated) && !is_string($lastCommunicated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastCommunicated)), __LINE__);
        }
        $this->lastCommunicated = $lastCommunicated;
        return $this;
    }
    /**
     * Get registration value
     * @return string|null
     */
    public function getRegistration()
    {
        return $this->registration;
    }
    /**
     * Set registration value
     * @param string $registration
     * @return \StructType\VehicleV2
     */
    public function setRegistration($registration = null)
    {
        // validation for constraint: string
        if (!is_null($registration) && !is_string($registration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registration)), __LINE__);
        }
        $this->registration = $registration;
        return $this;
    }
    /**
     * Get road value
     * @return string|null
     */
    public function getRoad()
    {
        return $this->road;
    }
    /**
     * Set road value
     * @param string $road
     * @return \StructType\VehicleV2
     */
    public function setRoad($road = null)
    {
        // validation for constraint: string
        if (!is_null($road) && !is_string($road)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road)), __LINE__);
        }
        $this->road = $road;
        return $this;
    }
    /**
     * Get town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->town;
    }
    /**
     * Set town value
     * @param string $town
     * @return \StructType\VehicleV2
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($town)), __LINE__);
        }
        $this->town = $town;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\VehicleV2
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\VehicleV2
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get driverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->driverName;
    }
    /**
     * Set driverName value
     * @param string $driverName
     * @return \StructType\VehicleV2
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverName)), __LINE__);
        }
        $this->driverName = $driverName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
