<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleUpdateResult StructType
 * @subpackage Structs
 */
class VehicleUpdateResult extends OpenElementElement
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorText;
    /**
     * The VehicleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleName;
    /**
     * Constructor method for VehicleUpdateResult
     * @uses VehicleUpdateResult::setSuccess()
     * @uses VehicleUpdateResult::setErrorText()
     * @uses VehicleUpdateResult::setVehicleName()
     * @param bool $success
     * @param string $errorText
     * @param string $vehicleName
     */
    public function __construct($success = null, $errorText = null, $vehicleName = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorText($errorText)
            ->setVehicleName($vehicleName);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\VehicleUpdateResult
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorText value
     * @return string|null
     */
    public function getErrorText()
    {
        return $this->ErrorText;
    }
    /**
     * Set ErrorText value
     * @param string $errorText
     * @return \StructType\VehicleUpdateResult
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorText)), __LINE__);
        }
        $this->ErrorText = $errorText;
        return $this;
    }
    /**
     * Get VehicleName value
     * @return string|null
     */
    public function getVehicleName()
    {
        return $this->VehicleName;
    }
    /**
     * Set VehicleName value
     * @param string $vehicleName
     * @return \StructType\VehicleUpdateResult
     */
    public function setVehicleName($vehicleName = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleName) && !is_string($vehicleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleName)), __LINE__);
        }
        $this->VehicleName = $vehicleName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleUpdateResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
