<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopCompletionDetails StructType
 * @subpackage Structs
 */
class StopCompletionDetails extends OpenElementElement
{
    /**
     * The PrintName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrintName;
    /**
     * The FeedbackNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeedbackNotes;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Signature;
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Result;
    /**
     * Constructor method for StopCompletionDetails
     * @uses StopCompletionDetails::setPrintName()
     * @uses StopCompletionDetails::setFeedbackNotes()
     * @uses StopCompletionDetails::setSignature()
     * @uses StopCompletionDetails::setResult()
     * @param string $printName
     * @param string $feedbackNotes
     * @param string $signature
     * @param string $result
     */
    public function __construct($printName = null, $feedbackNotes = null, $signature = null, $result = null)
    {
        $this
            ->setPrintName($printName)
            ->setFeedbackNotes($feedbackNotes)
            ->setSignature($signature)
            ->setResult($result);
    }
    /**
     * Get PrintName value
     * @return string|null
     */
    public function getPrintName()
    {
        return $this->PrintName;
    }
    /**
     * Set PrintName value
     * @param string $printName
     * @return \StructType\StopCompletionDetails
     */
    public function setPrintName($printName = null)
    {
        // validation for constraint: string
        if (!is_null($printName) && !is_string($printName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($printName)), __LINE__);
        }
        $this->PrintName = $printName;
        return $this;
    }
    /**
     * Get FeedbackNotes value
     * @return string|null
     */
    public function getFeedbackNotes()
    {
        return $this->FeedbackNotes;
    }
    /**
     * Set FeedbackNotes value
     * @param string $feedbackNotes
     * @return \StructType\StopCompletionDetails
     */
    public function setFeedbackNotes($feedbackNotes = null)
    {
        // validation for constraint: string
        if (!is_null($feedbackNotes) && !is_string($feedbackNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feedbackNotes)), __LINE__);
        }
        $this->FeedbackNotes = $feedbackNotes;
        return $this;
    }
    /**
     * Get Signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param string $signature
     * @return \StructType\StopCompletionDetails
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signature)), __LINE__);
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \StructType\StopCompletionDetails
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopCompletionDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
