<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NextServiceInformation StructType
 * @subpackage Structs
 */
class NextServiceInformation extends OpenElementElement
{
    /**
     * The ServiceOdometerReading
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOdometerReading;
    /**
     * The ServiceDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceDateTime;
    /**
     * The VehicleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleName;
    /**
     * Constructor method for NextServiceInformation
     * @uses NextServiceInformation::setServiceOdometerReading()
     * @uses NextServiceInformation::setServiceDateTime()
     * @uses NextServiceInformation::setVehicleName()
     * @param int $serviceOdometerReading
     * @param string $serviceDateTime
     * @param string $vehicleName
     */
    public function __construct($serviceOdometerReading = null, $serviceDateTime = null, $vehicleName = null)
    {
        $this
            ->setServiceOdometerReading($serviceOdometerReading)
            ->setServiceDateTime($serviceDateTime)
            ->setVehicleName($vehicleName);
    }
    /**
     * Get ServiceOdometerReading value
     * @return int
     */
    public function getServiceOdometerReading()
    {
        return $this->ServiceOdometerReading;
    }
    /**
     * Set ServiceOdometerReading value
     * @param int $serviceOdometerReading
     * @return \StructType\NextServiceInformation
     */
    public function setServiceOdometerReading($serviceOdometerReading = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOdometerReading) && !is_numeric($serviceOdometerReading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOdometerReading)), __LINE__);
        }
        $this->ServiceOdometerReading = $serviceOdometerReading;
        return $this;
    }
    /**
     * Get ServiceDateTime value
     * @return string
     */
    public function getServiceDateTime()
    {
        return $this->ServiceDateTime;
    }
    /**
     * Set ServiceDateTime value
     * @param string $serviceDateTime
     * @return \StructType\NextServiceInformation
     */
    public function setServiceDateTime($serviceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDateTime) && !is_string($serviceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceDateTime)), __LINE__);
        }
        $this->ServiceDateTime = $serviceDateTime;
        return $this;
    }
    /**
     * Get VehicleName value
     * @return string|null
     */
    public function getVehicleName()
    {
        return $this->VehicleName;
    }
    /**
     * Set VehicleName value
     * @param string $vehicleName
     * @return \StructType\NextServiceInformation
     */
    public function setVehicleName($vehicleName = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleName) && !is_string($vehicleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleName)), __LINE__);
        }
        $this->VehicleName = $vehicleName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NextServiceInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
