<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVehiclesAtContact StructType
 * @subpackage Structs
 */
class GetVehiclesAtContact extends AbstractStructBase
{
    /**
     * The contactCollectionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $contactCollectionType;
    /**
     * The minTimeAtContactMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $minTimeAtContactMinutes;
    /**
     * The maxTimeAtContactMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $maxTimeAtContactMinutes;
    /**
     * The vehicleCollectionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $vehicleCollectionType;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The contactsOrContactGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $contactsOrContactGroups;
    /**
     * The vehiclesOrVehicleGroupsFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $vehiclesOrVehicleGroupsFilter;
    /**
     * Constructor method for GetVehiclesAtContact
     * @uses GetVehiclesAtContact::setContactCollectionType()
     * @uses GetVehiclesAtContact::setMinTimeAtContactMinutes()
     * @uses GetVehiclesAtContact::setMaxTimeAtContactMinutes()
     * @uses GetVehiclesAtContact::setVehicleCollectionType()
     * @uses GetVehiclesAtContact::setLogin()
     * @uses GetVehiclesAtContact::setPassword()
     * @uses GetVehiclesAtContact::setContactsOrContactGroups()
     * @uses GetVehiclesAtContact::setVehiclesOrVehicleGroupsFilter()
     * @param string $contactCollectionType
     * @param int $minTimeAtContactMinutes
     * @param int $maxTimeAtContactMinutes
     * @param string $vehicleCollectionType
     * @param string $login
     * @param string $password
     * @param \ArrayType\ArrayOfString $contactsOrContactGroups
     * @param \ArrayType\ArrayOfString $vehiclesOrVehicleGroupsFilter
     */
    public function __construct($contactCollectionType = null, $minTimeAtContactMinutes = null, $maxTimeAtContactMinutes = null, $vehicleCollectionType = null, $login = null, $password = null, \ArrayType\ArrayOfString $contactsOrContactGroups = null, \ArrayType\ArrayOfString $vehiclesOrVehicleGroupsFilter = null)
    {
        $this
            ->setContactCollectionType($contactCollectionType)
            ->setMinTimeAtContactMinutes($minTimeAtContactMinutes)
            ->setMaxTimeAtContactMinutes($maxTimeAtContactMinutes)
            ->setVehicleCollectionType($vehicleCollectionType)
            ->setLogin($login)
            ->setPassword($password)
            ->setContactsOrContactGroups($contactsOrContactGroups)
            ->setVehiclesOrVehicleGroupsFilter($vehiclesOrVehicleGroupsFilter);
    }
    /**
     * Get contactCollectionType value
     * @return string
     */
    public function getContactCollectionType()
    {
        return $this->contactCollectionType;
    }
    /**
     * Set contactCollectionType value
     * @uses \EnumType\ContactCollectionType::valueIsValid()
     * @uses \EnumType\ContactCollectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contactCollectionType
     * @return \StructType\GetVehiclesAtContact
     */
    public function setContactCollectionType($contactCollectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactCollectionType::valueIsValid($contactCollectionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contactCollectionType, implode(', ', \EnumType\ContactCollectionType::getValidValues())), __LINE__);
        }
        $this->contactCollectionType = $contactCollectionType;
        return $this;
    }
    /**
     * Get minTimeAtContactMinutes value
     * @return int
     */
    public function getMinTimeAtContactMinutes()
    {
        return $this->minTimeAtContactMinutes;
    }
    /**
     * Set minTimeAtContactMinutes value
     * @param int $minTimeAtContactMinutes
     * @return \StructType\GetVehiclesAtContact
     */
    public function setMinTimeAtContactMinutes($minTimeAtContactMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($minTimeAtContactMinutes) && !is_numeric($minTimeAtContactMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minTimeAtContactMinutes)), __LINE__);
        }
        $this->minTimeAtContactMinutes = $minTimeAtContactMinutes;
        return $this;
    }
    /**
     * Get maxTimeAtContactMinutes value
     * @return int
     */
    public function getMaxTimeAtContactMinutes()
    {
        return $this->maxTimeAtContactMinutes;
    }
    /**
     * Set maxTimeAtContactMinutes value
     * @param int $maxTimeAtContactMinutes
     * @return \StructType\GetVehiclesAtContact
     */
    public function setMaxTimeAtContactMinutes($maxTimeAtContactMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($maxTimeAtContactMinutes) && !is_numeric($maxTimeAtContactMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxTimeAtContactMinutes)), __LINE__);
        }
        $this->maxTimeAtContactMinutes = $maxTimeAtContactMinutes;
        return $this;
    }
    /**
     * Get vehicleCollectionType value
     * @return string
     */
    public function getVehicleCollectionType()
    {
        return $this->vehicleCollectionType;
    }
    /**
     * Set vehicleCollectionType value
     * @uses \EnumType\VehicleCollectionType::valueIsValid()
     * @uses \EnumType\VehicleCollectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleCollectionType
     * @return \StructType\GetVehiclesAtContact
     */
    public function setVehicleCollectionType($vehicleCollectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleCollectionType::valueIsValid($vehicleCollectionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleCollectionType, implode(', ', \EnumType\VehicleCollectionType::getValidValues())), __LINE__);
        }
        $this->vehicleCollectionType = $vehicleCollectionType;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\GetVehiclesAtContact
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetVehiclesAtContact
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get contactsOrContactGroups value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getContactsOrContactGroups()
    {
        return $this->contactsOrContactGroups;
    }
    /**
     * Set contactsOrContactGroups value
     * @param \ArrayType\ArrayOfString $contactsOrContactGroups
     * @return \StructType\GetVehiclesAtContact
     */
    public function setContactsOrContactGroups(\ArrayType\ArrayOfString $contactsOrContactGroups = null)
    {
        $this->contactsOrContactGroups = $contactsOrContactGroups;
        return $this;
    }
    /**
     * Get vehiclesOrVehicleGroupsFilter value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getVehiclesOrVehicleGroupsFilter()
    {
        return $this->vehiclesOrVehicleGroupsFilter;
    }
    /**
     * Set vehiclesOrVehicleGroupsFilter value
     * @param \ArrayType\ArrayOfString $vehiclesOrVehicleGroupsFilter
     * @return \StructType\GetVehiclesAtContact
     */
    public function setVehiclesOrVehicleGroupsFilter(\ArrayType\ArrayOfString $vehiclesOrVehicleGroupsFilter = null)
    {
        $this->vehiclesOrVehicleGroupsFilter = $vehiclesOrVehicleGroupsFilter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVehiclesAtContact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
