<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for driver StructType
 * @subpackage Structs
 */
class Driver extends AbstractStructBase
{
    /**
     * The driverReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driverReference;
    /**
     * The driverName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driverName;
    /**
     * Constructor method for driver
     * @uses Driver::setDriverReference()
     * @uses Driver::setDriverName()
     * @param string $driverReference
     * @param string $driverName
     */
    public function __construct($driverReference = null, $driverName = null)
    {
        $this
            ->setDriverReference($driverReference)
            ->setDriverName($driverName);
    }
    /**
     * Get driverReference value
     * @return string|null
     */
    public function getDriverReference()
    {
        return $this->driverReference;
    }
    /**
     * Set driverReference value
     * @param string $driverReference
     * @return \StructType\Driver
     */
    public function setDriverReference($driverReference = null)
    {
        // validation for constraint: string
        if (!is_null($driverReference) && !is_string($driverReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverReference)), __LINE__);
        }
        $this->driverReference = $driverReference;
        return $this;
    }
    /**
     * Get driverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->driverName;
    }
    /**
     * Set driverName value
     * @param string $driverName
     * @return \StructType\Driver
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverName)), __LINE__);
        }
        $this->driverName = $driverName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Driver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
