<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createJob StructType
 * @subpackage Structs
 */
class CreateJob extends AbstractStructBase
{
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The job
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJob
     */
    public $job;
    /**
     * Constructor method for createJob
     * @uses CreateJob::setLogin()
     * @uses CreateJob::setPassword()
     * @uses CreateJob::setJob()
     * @param string $login
     * @param string $password
     * @param \ArrayType\ArrayOfJob $job
     */
    public function __construct($login = null, $password = null, \ArrayType\ArrayOfJob $job = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setJob($job);
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\CreateJob
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\CreateJob
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get job value
     * @return \ArrayType\ArrayOfJob|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \ArrayType\ArrayOfJob $job
     * @return \StructType\CreateJob
     */
    public function setJob(\ArrayType\ArrayOfJob $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateJob
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
