<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateAllocatedRouteResult StructType
 * @subpackage Structs
 */
class CreateAllocatedRouteResult extends AbstractStructBase
{
    /**
     * The Succeeded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Succeeded;
    /**
     * The FailureReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FailureReason;
    /**
     * The DeliveryResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCreateDeliveryResult
     */
    public $DeliveryResults;
    /**
     * Constructor method for CreateAllocatedRouteResult
     * @uses CreateAllocatedRouteResult::setSucceeded()
     * @uses CreateAllocatedRouteResult::setFailureReason()
     * @uses CreateAllocatedRouteResult::setDeliveryResults()
     * @param bool $succeeded
     * @param string $failureReason
     * @param \ArrayType\ArrayOfCreateDeliveryResult $deliveryResults
     */
    public function __construct($succeeded = null, $failureReason = null, \ArrayType\ArrayOfCreateDeliveryResult $deliveryResults = null)
    {
        $this
            ->setSucceeded($succeeded)
            ->setFailureReason($failureReason)
            ->setDeliveryResults($deliveryResults);
    }
    /**
     * Get Succeeded value
     * @return bool
     */
    public function getSucceeded()
    {
        return $this->Succeeded;
    }
    /**
     * Set Succeeded value
     * @param bool $succeeded
     * @return \StructType\CreateAllocatedRouteResult
     */
    public function setSucceeded($succeeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($succeeded) && !is_bool($succeeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($succeeded)), __LINE__);
        }
        $this->Succeeded = $succeeded;
        return $this;
    }
    /**
     * Get FailureReason value
     * @return string|null
     */
    public function getFailureReason()
    {
        return $this->FailureReason;
    }
    /**
     * Set FailureReason value
     * @param string $failureReason
     * @return \StructType\CreateAllocatedRouteResult
     */
    public function setFailureReason($failureReason = null)
    {
        // validation for constraint: string
        if (!is_null($failureReason) && !is_string($failureReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureReason)), __LINE__);
        }
        $this->FailureReason = $failureReason;
        return $this;
    }
    /**
     * Get DeliveryResults value
     * @return \ArrayType\ArrayOfCreateDeliveryResult|null
     */
    public function getDeliveryResults()
    {
        return $this->DeliveryResults;
    }
    /**
     * Set DeliveryResults value
     * @param \ArrayType\ArrayOfCreateDeliveryResult $deliveryResults
     * @return \StructType\CreateAllocatedRouteResult
     */
    public function setDeliveryResults(\ArrayType\ArrayOfCreateDeliveryResult $deliveryResults = null)
    {
        $this->DeliveryResults = $deliveryResults;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateAllocatedRouteResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
