<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllocatedVehicleRoute StructType
 * @subpackage Structs
 */
class AllocatedVehicleRoute extends AllocatedRoute
{
    /**
     * The ExpiryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpiryDate;
    /**
     * The AllocatedVehicleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllocatedVehicleName;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * Constructor method for AllocatedVehicleRoute
     * @uses AllocatedVehicleRoute::setExpiryDate()
     * @uses AllocatedVehicleRoute::setAllocatedVehicleName()
     * @uses AllocatedVehicleRoute::setReference()
     * @param string $expiryDate
     * @param string $allocatedVehicleName
     * @param string $reference
     */
    public function __construct($expiryDate = null, $allocatedVehicleName = null, $reference = null)
    {
        $this
            ->setExpiryDate($expiryDate)
            ->setAllocatedVehicleName($allocatedVehicleName)
            ->setReference($reference);
    }
    /**
     * Get ExpiryDate value
     * @return string
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\AllocatedVehicleRoute
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get AllocatedVehicleName value
     * @return string|null
     */
    public function getAllocatedVehicleName()
    {
        return $this->AllocatedVehicleName;
    }
    /**
     * Set AllocatedVehicleName value
     * @param string $allocatedVehicleName
     * @return \StructType\AllocatedVehicleRoute
     */
    public function setAllocatedVehicleName($allocatedVehicleName = null)
    {
        // validation for constraint: string
        if (!is_null($allocatedVehicleName) && !is_string($allocatedVehicleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allocatedVehicleName)), __LINE__);
        }
        $this->AllocatedVehicleName = $allocatedVehicleName;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\AllocatedVehicleRoute
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllocatedVehicleRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
