<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateDeliveryStart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDeliveryStart $parameters
     * @return \StructType\UpdateDeliveryStartResponse|bool
     */
    public function UpdateDeliveryStart(\StructType\UpdateDeliveryStart $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateDeliveryStart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDeliveryEnd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDeliveryEnd $parameters
     * @return \StructType\UpdateDeliveryEndResponse|bool
     */
    public function UpdateDeliveryEnd(\StructType\UpdateDeliveryEnd $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateDeliveryEnd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDeliveryCompletionDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDeliveryCompletionDetails $parameters
     * @return \StructType\UpdateDeliveryCompletionDetailsResponse|bool
     */
    public function UpdateDeliveryCompletionDetails(\StructType\UpdateDeliveryCompletionDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateDeliveryCompletionDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDeliveryCompletionDetailsV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDeliveryCompletionDetailsV2 $parameters
     * @return \StructType\UpdateDeliveryCompletionDetailsV2Response|bool
     */
    public function UpdateDeliveryCompletionDetailsV2(\StructType\UpdateDeliveryCompletionDetailsV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateDeliveryCompletionDetailsV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDeliveryLineItemQuantities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDeliveryLineItemQuantities $parameters
     * @return \StructType\UpdateDeliveryLineItemQuantitiesResponse|bool
     */
    public function UpdateDeliveryLineItemQuantities(\StructType\UpdateDeliveryLineItemQuantities $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateDeliveryLineItemQuantities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateDeliveryCompletionDetailsResponse|\StructType\UpdateDeliveryCompletionDetailsV2Response|\StructType\UpdateDeliveryEndResponse|\StructType\UpdateDeliveryLineItemQuantitiesResponse|\StructType\UpdateDeliveryStartResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
