<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetVehicleNextServiceInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetVehicleNextServiceInformation $parameters
     * @return \StructType\SetVehicleNextServiceInformationResponse|bool
     */
    public function SetVehicleNextServiceInformation(\StructType\SetVehicleNextServiceInformation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetVehicleNextServiceInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetGroupForVehicles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetGroupForVehicles $parameters
     * @return \StructType\SetGroupForVehiclesResponse|bool
     */
    public function SetGroupForVehicles(\StructType\SetGroupForVehicles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetGroupForVehicles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetGroupForVehiclesResponse|\StructType\SetVehicleNextServiceInformationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
