<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getJobCollection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetJobCollection $parameters
     * @return \StructType\GetJobCollectionResponse|bool
     */
    public function getJobCollection(\StructType\GetJobCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getJobCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getJobCollectionV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetJobCollectionV2 $parameters
     * @return \StructType\GetJobCollectionV2Response|bool
     */
    public function getJobCollectionV2(\StructType\GetJobCollectionV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getJobCollectionV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCurrentDrivers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrentDrivers $parameters
     * @return \StructType\GetCurrentDriversResponse|bool
     */
    public function getCurrentDrivers(\StructType\GetCurrentDrivers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCurrentDrivers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNearestVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNearestVehicle $parameters
     * @return \StructType\GetNearestVehicleResponse|bool
     */
    public function getNearestVehicle(\StructType\GetNearestVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNearestVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNearestVehicleV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNearestVehicleV2 $parameters
     * @return \StructType\GetNearestVehicleV2Response|bool
     */
    public function getNearestVehicleV2(\StructType\GetNearestVehicleV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNearestVehicleV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVehicleUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleUpdate $parameters
     * @return \StructType\GetVehicleUpdateResponse|bool
     */
    public function getVehicleUpdate(\StructType\GetVehicleUpdate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVehicleUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVehicleUpdateV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleUpdateV2 $parameters
     * @return \StructType\GetVehicleUpdateV2Response|bool
     */
    public function getVehicleUpdateV2(\StructType\GetVehicleUpdateV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVehicleUpdateV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHistory $parameters
     * @return \StructType\GetHistoryResponse|bool
     */
    public function GetHistory(\StructType\GetHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHistoryV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHistoryV2 $parameters
     * @return \StructType\GetHistoryV2Response|bool
     */
    public function GetHistoryV2(\StructType\GetHistoryV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetHistoryV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehiclesAtContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehiclesAtContact $parameters
     * @return \StructType\GetVehiclesAtContactResponse|bool
     */
    public function GetVehiclesAtContact(\StructType\GetVehiclesAtContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehiclesAtContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVersion $parameters
     * @return \StructType\GetVersionResponse|bool
     */
    public function GetVersion(\StructType\GetVersion $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetVehicleCalculatedCurrentOdometerReadings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleCalculatedCurrentOdometerReadings $parameters
     * @return \StructType\GetVehicleCalculatedCurrentOdometerReadingsResponse|bool
     */
    public function GetVehicleCalculatedCurrentOdometerReadings(\StructType\GetVehicleCalculatedCurrentOdometerReadings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleCalculatedCurrentOdometerReadings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryStatusChange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveryStatusChange $parameters
     * @return \StructType\GetDeliveryStatusChangeResponse|bool
     */
    public function GetDeliveryStatusChange(\StructType\GetDeliveryStatusChange $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDeliveryStatusChange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDistanceTravelled
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDistanceTravelled $parameters
     * @return \StructType\GetDistanceTravelledResponse|bool
     */
    public function GetDistanceTravelled(\StructType\GetDistanceTravelled $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDistanceTravelled($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCurrentDriversResponse|\StructType\GetDeliveryStatusChangeResponse|\StructType\GetDistanceTravelledResponse|\StructType\GetHistoryResponse|\StructType\GetHistoryV2Response|\StructType\GetJobCollectionResponse|\StructType\GetJobCollectionV2Response|\StructType\GetNearestVehicleResponse|\StructType\GetNearestVehicleV2Response|\StructType\GetVehicleCalculatedCurrentOdometerReadingsResponse|\StructType\GetVehiclesAtContactResponse|\StructType\GetVehicleUpdateResponse|\StructType\GetVehicleUpdateV2Response|\StructType\GetVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
