<?php

namespace EnumType;

/**
 * This class stands for VehicleType EnumType
 * @subpackage Enumerations
 */
class VehicleType
{
    /**
     * Constant for value 'CarLGV'
     * @return string 'CarLGV'
     */
    const VALUE_CAR_LGV = 'CarLGV';
    /**
     * Constant for value 'HGV'
     * @return string 'HGV'
     */
    const VALUE_HGV = 'HGV';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CAR_LGV
     * @uses self::VALUE_HGV
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CAR_LGV,
            self::VALUE_HGV,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
