<?php

namespace EnumType;

/**
 * This class stands for EventCode EnumType
 * @subpackage Enumerations
 */
class EventCode
{
    /**
     * Constant for value 'Temperature'
     * @return string 'Temperature'
     */
    const VALUE_TEMPERATURE = 'Temperature';
    /**
     * Constant for value 'Alert'
     * @return string 'Alert'
     */
    const VALUE_ALERT = 'Alert';
    /**
     * Constant for value 'VehicleLocation'
     * @return string 'VehicleLocation'
     */
    const VALUE_VEHICLE_LOCATION = 'VehicleLocation';
    /**
     * Constant for value 'Ignition'
     * @return string 'Ignition'
     */
    const VALUE_IGNITION = 'Ignition';
    /**
     * Constant for value 'AnalogueInput'
     * @return string 'AnalogueInput'
     */
    const VALUE_ANALOGUE_INPUT = 'AnalogueInput';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TEMPERATURE
     * @uses self::VALUE_ALERT
     * @uses self::VALUE_VEHICLE_LOCATION
     * @uses self::VALUE_IGNITION
     * @uses self::VALUE_ANALOGUE_INPUT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TEMPERATURE,
            self::VALUE_ALERT,
            self::VALUE_VEHICLE_LOCATION,
            self::VALUE_IGNITION,
            self::VALUE_ANALOGUE_INPUT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
