<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfXmlElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfXmlElement extends AbstractStructArrayBase
{
    /**
     * The XmlElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XmlElement[]
     */
    public $XmlElement;
    /**
     * Constructor method for ArrayOfXmlElement
     * @uses ArrayOfXmlElement::setXmlElement()
     * @param \StructType\XmlElement[] $xmlElement
     */
    public function __construct(array $xmlElement = array())
    {
        $this
            ->setXmlElement($xmlElement);
    }
    /**
     * Get XmlElement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XmlElement[]|null
     */
    public function getXmlElement()
    {
        return isset($this->XmlElement) ? $this->XmlElement : null;
    }
    /**
     * Set XmlElement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\XmlElement[] $xmlElement
     * @return \ArrayType\ArrayOfXmlElement
     */
    public function setXmlElement(array $xmlElement = array())
    {
        foreach ($xmlElement as $arrayOfXmlElementXmlElementItem) {
            // validation for constraint: itemType
            if (!$arrayOfXmlElementXmlElementItem instanceof \StructType\XmlElement) {
                throw new \InvalidArgumentException(sprintf('The XmlElement property can only contain items of \StructType\XmlElement, "%s" given', is_object($arrayOfXmlElementXmlElementItem) ? get_class($arrayOfXmlElementXmlElementItem) : gettype($arrayOfXmlElementXmlElementItem)), __LINE__);
            }
        }
        if (is_null($xmlElement) || (is_array($xmlElement) && empty($xmlElement))) {
            unset($this->XmlElement);
        } else {
            $this->XmlElement = $xmlElement;
        }
        return $this;
    }
    /**
     * Add item to XmlElement value
     * @throws \InvalidArgumentException
     * @param \StructType\XmlElement $item
     * @return \ArrayType\ArrayOfXmlElement
     */
    public function addToXmlElement(\StructType\XmlElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XmlElement) {
            throw new \InvalidArgumentException(sprintf('The XmlElement property can only contain items of \StructType\XmlElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->XmlElement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\XmlElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\XmlElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\XmlElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\XmlElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\XmlElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string XmlElement
     */
    public function getAttributeName()
    {
        return 'XmlElement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfXmlElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
