<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVehicleEvent ArrayType
 * @subpackage Arrays
 */
class ArrayOfVehicleEvent extends AbstractStructArrayBase
{
    /**
     * The VehicleEvent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VehicleEvent[]
     */
    public $VehicleEvent;
    /**
     * Constructor method for ArrayOfVehicleEvent
     * @uses ArrayOfVehicleEvent::setVehicleEvent()
     * @param \StructType\VehicleEvent[] $vehicleEvent
     */
    public function __construct(array $vehicleEvent = array())
    {
        $this
            ->setVehicleEvent($vehicleEvent);
    }
    /**
     * Get VehicleEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VehicleEvent[]|null
     */
    public function getVehicleEvent()
    {
        return isset($this->VehicleEvent) ? $this->VehicleEvent : null;
    }
    /**
     * Set VehicleEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleEvent[] $vehicleEvent
     * @return \ArrayType\ArrayOfVehicleEvent
     */
    public function setVehicleEvent(array $vehicleEvent = array())
    {
        foreach ($vehicleEvent as $arrayOfVehicleEventVehicleEventItem) {
            // validation for constraint: itemType
            if (!$arrayOfVehicleEventVehicleEventItem instanceof \StructType\VehicleEvent) {
                throw new \InvalidArgumentException(sprintf('The VehicleEvent property can only contain items of \StructType\VehicleEvent, "%s" given', is_object($arrayOfVehicleEventVehicleEventItem) ? get_class($arrayOfVehicleEventVehicleEventItem) : gettype($arrayOfVehicleEventVehicleEventItem)), __LINE__);
            }
        }
        if (is_null($vehicleEvent) || (is_array($vehicleEvent) && empty($vehicleEvent))) {
            unset($this->VehicleEvent);
        } else {
            $this->VehicleEvent = $vehicleEvent;
        }
        return $this;
    }
    /**
     * Add item to VehicleEvent value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleEvent $item
     * @return \ArrayType\ArrayOfVehicleEvent
     */
    public function addToVehicleEvent(\StructType\VehicleEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleEvent) {
            throw new \InvalidArgumentException(sprintf('The VehicleEvent property can only contain items of \StructType\VehicleEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleEvent[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VehicleEvent|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VehicleEvent|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VehicleEvent|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VehicleEvent|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VehicleEvent|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VehicleEvent
     */
    public function getAttributeName()
    {
        return 'VehicleEvent';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVehicleEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
