<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleHistoryV2 StructType
 * @subpackage Structs
 */
class VehicleHistoryV2 extends OpenElementElement
{
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Speed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Speed;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Direction;
    /**
     * The PositionDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PositionDateTime;
    /**
     * The LastDataTransferDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastDataTransferDateTime;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Code;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationName;
    /**
     * The LocationReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationReference;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Postcode;
    /**
     * The Town
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Town;
    /**
     * The Road
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Road;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Events
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfVehicleEvent
     */
    public $Events;
    /**
     * Constructor method for VehicleHistoryV2
     * @uses VehicleHistoryV2::setLatitude()
     * @uses VehicleHistoryV2::setLongitude()
     * @uses VehicleHistoryV2::setSpeed()
     * @uses VehicleHistoryV2::setDirection()
     * @uses VehicleHistoryV2::setPositionDateTime()
     * @uses VehicleHistoryV2::setLastDataTransferDateTime()
     * @uses VehicleHistoryV2::setCode()
     * @uses VehicleHistoryV2::setLocationName()
     * @uses VehicleHistoryV2::setLocationReference()
     * @uses VehicleHistoryV2::setCountry()
     * @uses VehicleHistoryV2::setPostcode()
     * @uses VehicleHistoryV2::setTown()
     * @uses VehicleHistoryV2::setRoad()
     * @uses VehicleHistoryV2::setName()
     * @uses VehicleHistoryV2::setEvents()
     * @param float $latitude
     * @param float $longitude
     * @param int $speed
     * @param int $direction
     * @param string $positionDateTime
     * @param string $lastDataTransferDateTime
     * @param int $code
     * @param string $locationName
     * @param string $locationReference
     * @param string $country
     * @param string $postcode
     * @param string $town
     * @param string $road
     * @param string $name
     * @param \ArrayType\ArrayOfVehicleEvent $events
     */
    public function __construct($latitude = null, $longitude = null, $speed = null, $direction = null, $positionDateTime = null, $lastDataTransferDateTime = null, $code = null, $locationName = null, $locationReference = null, $country = null, $postcode = null, $town = null, $road = null, $name = null, \ArrayType\ArrayOfVehicleEvent $events = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setSpeed($speed)
            ->setDirection($direction)
            ->setPositionDateTime($positionDateTime)
            ->setLastDataTransferDateTime($lastDataTransferDateTime)
            ->setCode($code)
            ->setLocationName($locationName)
            ->setLocationReference($locationReference)
            ->setCountry($country)
            ->setPostcode($postcode)
            ->setTown($town)
            ->setRoad($road)
            ->setName($name)
            ->setEvents($events);
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\VehicleHistoryV2
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\VehicleHistoryV2
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Speed value
     * @return int
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param int $speed
     * @return \StructType\VehicleHistoryV2
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !is_numeric($speed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get Direction value
     * @return int
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param int $direction
     * @return \StructType\VehicleHistoryV2
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: int
        if (!is_null($direction) && !is_numeric($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get PositionDateTime value
     * @return string
     */
    public function getPositionDateTime()
    {
        return $this->PositionDateTime;
    }
    /**
     * Set PositionDateTime value
     * @param string $positionDateTime
     * @return \StructType\VehicleHistoryV2
     */
    public function setPositionDateTime($positionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($positionDateTime) && !is_string($positionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($positionDateTime)), __LINE__);
        }
        $this->PositionDateTime = $positionDateTime;
        return $this;
    }
    /**
     * Get LastDataTransferDateTime value
     * @return string
     */
    public function getLastDataTransferDateTime()
    {
        return $this->LastDataTransferDateTime;
    }
    /**
     * Set LastDataTransferDateTime value
     * @param string $lastDataTransferDateTime
     * @return \StructType\VehicleHistoryV2
     */
    public function setLastDataTransferDateTime($lastDataTransferDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDataTransferDateTime) && !is_string($lastDataTransferDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDataTransferDateTime)), __LINE__);
        }
        $this->LastDataTransferDateTime = $lastDataTransferDateTime;
        return $this;
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\VehicleHistoryV2
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \StructType\VehicleHistoryV2
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationName)), __LINE__);
        }
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get LocationReference value
     * @return string|null
     */
    public function getLocationReference()
    {
        return $this->LocationReference;
    }
    /**
     * Set LocationReference value
     * @param string $locationReference
     * @return \StructType\VehicleHistoryV2
     */
    public function setLocationReference($locationReference = null)
    {
        // validation for constraint: string
        if (!is_null($locationReference) && !is_string($locationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationReference)), __LINE__);
        }
        $this->LocationReference = $locationReference;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\VehicleHistoryV2
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\VehicleHistoryV2
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get Town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->Town;
    }
    /**
     * Set Town value
     * @param string $town
     * @return \StructType\VehicleHistoryV2
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($town)), __LINE__);
        }
        $this->Town = $town;
        return $this;
    }
    /**
     * Get Road value
     * @return string|null
     */
    public function getRoad()
    {
        return $this->Road;
    }
    /**
     * Set Road value
     * @param string $road
     * @return \StructType\VehicleHistoryV2
     */
    public function setRoad($road = null)
    {
        // validation for constraint: string
        if (!is_null($road) && !is_string($road)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road)), __LINE__);
        }
        $this->Road = $road;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\VehicleHistoryV2
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Events value
     * @return \ArrayType\ArrayOfVehicleEvent|null
     */
    public function getEvents()
    {
        return $this->Events;
    }
    /**
     * Set Events value
     * @param \ArrayType\ArrayOfVehicleEvent $events
     * @return \StructType\VehicleHistoryV2
     */
    public function setEvents(\ArrayType\ArrayOfVehicleEvent $events = null)
    {
        $this->Events = $events;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleHistoryV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
